package com.bcxin.tenant.domain.services.commands;

import com.bcxin.Infrastructures.TenantContext;
import com.bcxin.Infrastructures.TenantUserContext;
import com.bcxin.Infrastructures.commands.CommandAbstract;
import com.bcxin.Infrastructures.exceptions.ArgumentTenantException;
import com.bcxin.Infrastructures.exceptions.NotAllowedTenantException;
import lombok.Getter;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import java.util.Collection;

@Getter
public class BatchDeleteDepartAdminCommand extends CommandAbstract {
    private final String organizationId;
    private final Collection<String> employeeIds;

    public BatchDeleteDepartAdminCommand(String organizationId, Collection<String> employeeIds) {
        this.organizationId = organizationId;
        this.employeeIds = employeeIds;
    }

    @Override
    public void validate() {
        if (!TenantContext.getInstance().getUserContext().isDomainAdmin()) {
            throw new NotAllowedTenantException("非组织管理员不允许执行该操作");
        }

        if (!StringUtils.hasLength(this.getOrganizationId())) {
            throw new ArgumentTenantException("操作的企业无效!");
        }

        if (CollectionUtils.isEmpty(this.getEmployeeIds()) || this.getEmployeeIds().stream().anyMatch(ii -> !StringUtils.hasLength(ii))) {
            throw new ArgumentTenantException("职员信息无效!");
        }
    }

    public static BatchDeleteDepartAdminCommand create(String organizationId, Collection<String> employeeIds) {
        return new BatchDeleteDepartAdminCommand(organizationId, employeeIds);
    }
}
