package com.bcxin.tenant.domain.services.commands;

import com.bcxin.Infrastructures.commands.CommandAbstract;
import com.bcxin.Infrastructures.enums.CredentialType;
import lombok.Getter;

import java.util.Collection;

@Getter
public class BatchCreateTenantUserCommand extends CommandAbstract {
    private final Collection<TenantUserCommandItem> items;

    public BatchCreateTenantUserCommand(Collection<TenantUserCommandItem> items) {
        this.items = items;
    }

    public static BatchCreateTenantUserCommand create(Collection<TenantUserCommandItem> items) {
        return new BatchCreateTenantUserCommand(items);
    }

    @Getter
    public static class TenantUserCommandItem
    {
        private final String name;
        private final String telephone;
        private final CredentialType credentialType;
        private final String credentialNumber;
        private final String nationality;

        public TenantUserCommandItem(String name, String telephone,
                                     CredentialType credentialType, String credentialNumber, String nationality) {
            this.name = name;
            this.telephone = telephone;
            this.credentialType = credentialType;
            this.credentialNumber = credentialNumber;
            this.nationality = nationality;
        }

        public static TenantUserCommandItem create(String name, String telephone,
                                                   CredentialType credentialType, String credentialNumber, String nationality) {
            return new TenantUserCommandItem(name, telephone, credentialType, credentialNumber, nationality);
        }
    }
}
