package com.bcxin.tenant.domain.services;
import com.bcxin.tenant.domain.entities.TenantUserEntity;
import com.bcxin.tenant.domain.services.commands.BatchCreateTenantUserCommand;
import com.bcxin.tenant.domain.services.commands.CreateTenantUserByEmployeeCommand;
import com.bcxin.tenant.domain.services.commands.SyncTenantUserLocationCommand;
import com.bcxin.tenant.domain.services.commands.UpdateTenantUserCommand;
import com.bcxin.tenant.domain.services.commands.tenantUsers.*;

import java.util.Collection;

public interface TenantUserService {
    void create(CreateTenantUserByEmployeeCommand command);

    Collection<TenantUserEntity> create(BatchCreateTenantUserCommand command);

    void dispatch(UpdateTenantUserCommand command);

    void dispatch(SyncTenantUserLocationCommand command);

    void dispatch(SyncDeviceCommand command);

    void dispatch(SyncWechatLabelCommand command);

    void dispatch(UpdateBasicTenantUserCommand command);

    void dispatch(UpdateCredentialCommand command);

    void dispatch(UpdateUserCredentialCommand command);

    void dispatch(UpdateUserPhotoCommand command);

    /**
     * description：修改昵称/头像
     * author：linchunpeng
     * date：2025/5/20
     */
    void dispatch(UpdateUserNickHeadPhotoCommand command);

    void dispatch(RedoAuthorizationCommand command);

    void dispatch(NotifyNewUserCommand command);

    void createAppeal(CreateAuthAppealCommand command);

    void dispatch(PlatformUpdateUserBasicCommand command);

    void dispatch(PlatformResetAuthenticateStatusCommand command);

    void dispatch(PlatformResetPasswordCommand command);

    TocWechatCgiConfirmCheckStatusCommand.TocWechatCgiConfirmCheckStatusCommandResult dispatch(TocWechatCgiConfirmCheckStatusCommand command);
}