package com.bcxin.tenant.domain.repositories.dtos;

import com.bcxin.Infrastructures.enums.InviteType;
import com.bcxin.Infrastructures.enums.RelationshipsStatus;
import lombok.Data;

import java.util.Date;

@Data
public class OrganizationRelationshipInfoDto {
    private Long id;

    private String parentId;

    private String parentName;

    private String selectedOrganizationId;

    private String selectedOrganizationName;

    private String selectedOrganizationNote;

    private String code;

    private String contactName;

    private String contactTelephone;

    private OrganizationTypeDto organizationType;

    private String relationshipIndexTree;

    private RelationshipsStatus status;

    private String lastReplyNote;

    private String lastReplyEmployeeId;

    private String lastReplyEmployeeName;

    private Date lastReplyTime;

    private  String organizationId;

    private InviteType inviteType;

    private OrganizationStatisticsDto organizationStatistics;

    public OrganizationRelationshipInfoDto(Long id,
                                           String parentId,
                                           String parentName,
                                           String selectedOrganizationId,
                                           String selectedOrganizationName,
                                           String selectedOrganizationNote,
                                           String code,
                                           String contactName,
                                           String contactTelephone,
                                           Long orgTypeId,
                                           String orgTypeName,
                                           String orgTypeNote,
                                           String orgTypeOrgId,
                                           String relationshipIndexTree,
                                           RelationshipsStatus status,
                                           String lastReplyNote,
                                           String lastReplyEmployeeId,
                                           String lastReplyEmployeeName,
                                           Date lastReplyTime,
                                           String organizationId,
                                           InviteType inviteType,
                                           String staticId,
                                           String unifySocialCreditCode,
                                           Integer countOfMembers
    ) {
        this.id = id;
        this.parentId = parentId;
        this.parentName = parentName;
        this.selectedOrganizationId = selectedOrganizationId;
        this.selectedOrganizationName = selectedOrganizationName;
        this.selectedOrganizationNote = selectedOrganizationNote;
        this.code = code;
        this.contactName = contactName;
        this.contactTelephone = contactTelephone;
        this.organizationType = orgTypeId == null ? null : new OrganizationTypeDto(orgTypeId,orgTypeName,orgTypeNote,orgTypeOrgId);
        this.relationshipIndexTree = relationshipIndexTree;
        this.status = status;
        this.lastReplyNote = lastReplyNote;
        this.lastReplyEmployeeId = lastReplyEmployeeId;
        this.lastReplyEmployeeName = lastReplyEmployeeName;
        this.lastReplyTime = lastReplyTime;
        this.organizationId = organizationId;
        this.inviteType = inviteType;
        this.organizationStatistics = staticId == null ? null : new OrganizationStatisticsDto(
                selectedOrganizationId,
                unifySocialCreditCode,
                countOfMembers.longValue()
                );
    }
}
