package com.bcxin.tenant.domain.repositories.dtos;

import com.alibaba.excel.annotation.ExcelIgnore;
import com.alibaba.excel.annotation.ExcelProperty;
import com.bcxin.Infrastructures.entities.OperatorValueType;
import com.bcxin.Infrastructures.enums.CredentialType;
import com.bcxin.Infrastructures.enums.EmploymentStatus;
import com.bcxin.Infrastructures.enums.TrueFalseStatus;
import com.bcxin.Infrastructures.enums.ValidStatus;
import com.bcxin.Infrastructures.utils.DateUtil;
import lombok.Data;
import org.springframework.util.StringUtils;

import javax.persistence.*;
import java.text.SimpleDateFormat;
import java.util.Date;

@Data
public class ContractExportDto {

    @ExcelIgnore
    private String employeeId;
    //合同名称、关联员工姓名、关联员工手机号、甲方名称、乙方名称、合同开始时间、合同结束时间、是否为无期限合同、合同状态、备注
    @ExcelProperty("合同名称")
    private String name;
    @ExcelProperty("关联员工姓名")
    private String employeeName;
    @ExcelProperty("关联员工所在部门")
    private String employeeDepartName;
    @ExcelProperty("关联员工手机号")
    private String employeeTelephone;

    @ExcelIgnore
    private CredentialType credentialType;
    @ExcelProperty("关联员工证件类型")
    private String employeeIdType;
    @ExcelProperty("关联员工证件号")
    private String employeeIdNum;
    @ExcelProperty("甲方名称")
    private String aName;
    @ExcelProperty("乙方名称")
    private String bName;
    @ExcelProperty(value = "合同开始时间")
    private String beginTime;
    @Temporal(TemporalType.DATE)
    @ExcelIgnore
    private Date beginDate;
    @ExcelProperty("合同结束时间")
    private String endTime;
    @ExcelIgnore
    @Temporal(TemporalType.DATE)
    private Date endDate;
    @ExcelProperty("是否为无期限合同")
    private String dateLimitlessName;
    @ExcelIgnore
    private TrueFalseStatus dateLimitless;
    /**
     * 合同状态 是否有效
     * 当职员离职的时候，该合同就自动失效
     */
    @ExcelProperty("合同状态")
    private String statusName;
    @ExcelIgnore
    @Enumerated(EnumType.ORDINAL)
    private ValidStatus status;
    @ExcelProperty("备注")
    private String note;

    @ExcelIgnore
    private String attachment;

    @ExcelIgnore
    private EmploymentStatus employeeStatus;
    @ExcelIgnore
    private OperatorValueType lastModifier;
    @ExcelIgnore
    private OperatorValueType creator;

    @ExcelProperty("更新人")
    private String operatorName;

    @ExcelProperty("更新时间")
    private String operatorTime;

    @ExcelProperty("创建日期")
    private String createdTime;

    public ContractExportDto(String employeeId,
                             String name,
                             String employeeName,
                             String employeeTelephone,
                             CredentialType credentialType,
                             String employeeIdNum,
                             String aName,
                             String bName,
                             Date beginDate,
                             Date endDate,
                             TrueFalseStatus dateLimitless,
                             ValidStatus status,
                             String note,
                             String attachment,
                             EmploymentStatus employeeStatus,
                             OperatorValueType lastModifier,
                             OperatorValueType creator
    ) {
        this.employeeId = employeeId;
        this.name = name;
        this.employeeName = employeeName;
        this.employeeTelephone = employeeTelephone;
        this.credentialType = credentialType;
        this.employeeIdNum = employeeIdNum;
        this.aName = aName;
        this.bName = bName;
        this.beginDate = beginDate;
        this.endDate = endDate;
        this.dateLimitless =dateLimitless;
        this.status = status;
        this.note = note;
        this.attachment = attachment;
        this.employeeStatus = employeeStatus;

        if(credentialType != null){
            this.employeeIdType = credentialType.getTypeName();
        }

        if(beginDate != null){
            this.beginTime = DateUtil.format2ShortDate(beginDate);
        }

        if(endDate != null){
            this.endTime = DateUtil.format2ShortDate(endDate);
        }

        if(dateLimitless != null){
            this.dateLimitlessName = dateLimitless.getTypeName();
        }

        Date today = new Date();
        if (this.getStatus() == ValidStatus.InValid ||this.getEmployeeStatus() == EmploymentStatus.OffJob ||
                (this.getEndDate() != null && this.getEndDate().before(today))) {
            this.statusName = "终止";
        }else if (!StringUtils.hasLength(attachment)) {
            this.statusName = "待完善";
        }else if (this.getBeginDate().after(today)) {
            this.statusName = "待生效";
        }else{
            this.statusName = "生效中";
        }

        if(lastModifier != null){
            this.operatorName = lastModifier.getName();
            this.operatorTime = lastModifier.getOperatorTime();
        }

        if(creator != null){
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
            if (creator.getCreatedTime() == null) {
                this.createdTime = null;
            } else {
                this.createdTime = dateFormat.format(creator.getCreatedTime());
            }
        }

    }

    public void setEmployeeDepartName(String employeeDepartName) {
        this.employeeDepartName = employeeDepartName;
    }
}
