package com.bcxin.tenant.domain.repositories.criterias;

import com.bcxin.api.interfaces.CriteriaAbstract;
import lombok.Getter;

@Getter
public class ExternalGroupSearchCriteria extends CriteriaAbstract {
    private final String organizationId;
    private final String keyword;

    public ExternalGroupSearchCriteria(String organizationId, String keyword) {
        this.organizationId = organizationId;
        this.keyword = keyword;
    }

    public static ExternalGroupSearchCriteria create(String organizationId, String keyword) {
        return new ExternalGroupSearchCriteria(organizationId, keyword);
    }
}
