package com.bcxin.tenant.domain.repositories;

import com.bcxin.Infrastructures.EntityRepository;
import com.bcxin.tenant.domain.entities.SysInstitutionalTypeEntity;

import java.util.Collection;

public interface SysInstitutionalTypeRepository extends EntityRepository<SysInstitutionalTypeEntity, String> {

    /**
     * 根据行业ID和是否删除状态查询机构类型列表
     * @param industryId 行业ID
     * @param isDeleted 是否删除(0-未删除,1-已删除)
     * @return 机构类型列表
     */
    Collection<SysInstitutionalTypeEntity> findByIndustryIdAndIsDeleted(String industryId, Integer isDeleted);

    /**
     * 根据机构类型编码和是否删除状态查询机构类型
     * @param code 机构类型编码
     * @param isDeleted 是否删除(0-未删除,1-已删除)
     * @return 机构类型
     */
    SysInstitutionalTypeEntity findByCodeAndIsDeleted(String code, Integer isDeleted);
}


