package com.bcxin.tenant.domain.repositories;

import com.bcxin.Infrastructures.EntityRepository;
import com.bcxin.tenant.domain.entities.SuperviseDepartmentEntity;

import java.util.List;

/**
 * description: 监管机构DAO
 * author: linchunpeng
 * date:  2023-05-09 18:46
 */
public interface SuperviseDepartmentRepository extends EntityRepository<SuperviseDepartmentEntity, Long> {

    List<SuperviseDepartmentEntity> findByRegionIdStartWith(String regionStartWith);

    /**
     * 根据区域ID前缀和行业代码查询监管机构
     * @param regionStartWith 区域ID前缀
     * @param industryCode 行业代码（如 "01", "06"）
     * @return 监管机构列表
     */
    List<SuperviseDepartmentEntity> findByRegionIdStartWithAndIndustryCode(String regionStartWith, String industryCode);

}
