package com.bcxin.tenant.domain.repositories;

import com.bcxin.Infrastructures.EntityRepository;
import com.bcxin.tenant.domain.entities.DepartmentEntity;
import com.bcxin.tenant.domain.repositories.dtos.DepartmentDto;

import java.util.Collection;
import java.util.List;

public interface DepartmentRepository extends EntityRepository<DepartmentEntity,String> {
    Collection<DepartmentDto> getDtoByOrganIdAndParentId(String organId, String parentId);

    DepartmentDto getDtoByOrganIdAndId(String organId, String id);

    Collection<DepartmentDto> getRootDtoByOrganId(String organId);

    Collection<DepartmentDto> getDtosByOrganId(String organId);

    Collection<DepartmentEntity> getDepartAndRootByOrganIdName(String organId, Collection<String> names);

    Collection<DepartmentEntity> getRootsByOrganId(String organId);

    Collection<DepartmentEntity> getByIds(String organizationId, Collection<String> ids);

    int deleteByIds(String organId, Collection<String> ids);

    Collection<DepartmentEntity> getAllByOrganId(String organId);

    DepartmentEntity getByOrganIdAndCode(String organId, String code);

    DepartmentEntity getRootByOrganId(String organId);

    void clearDuplicatedEmployeeRelationIds(Collection<String> ids);

    void clearDuplicatedEmployeeRelationByEmployeeIds(Collection<String> employeeIds);

    void clearDuplicatedEmployeeRelationByEmployeeIdsAndDepartId(Collection<String> employeeIds, String destDepartId);

    void clearDepartmentAdminByDepartIds(Collection<String> destDepartIds);

    int updateTreeByDepartmentIndexTree1(String oldTree, String newTree, String organizationId, String oldTreeLike);

    int updateTreeByDepartmentIndexTree2(String oldTree, String newTree, String organizationId, String oldTreeLike);

    int updateTreeByDepartmentIndexTree3(String oldTree, String newTree, String organizationId, String oldTreeLike);

    List<DepartmentEntity> findBySelfAndChild(String organizationId, String indexTree);
}
