package com.bcxin.tenant.domain.readers.dtos;

import cn.hutool.core.util.StrUtil;
import com.bcxin.Infrastructures.entities.OperatorValueType;
import com.bcxin.Infrastructures.enums.*;
import com.bcxin.tenant.domain.entities.valueTypes.LocationValueType;
import lombok.Getter;

import javax.persistence.*;
import java.util.Date;

@Getter
public class EmployeeDto {
    private final String userId;
    private final String id;
    private final String name;
    private final String telephone;
    private String departId;
    private String departName;
    private Boolean departLeader;
    private final String organName;
    private final CredentialType credentialType;
    //证件号码
    private final String credentialNumber;
    private final UserCheckedStatus checkedStatus;
    private final UserType userType;
    private final OccupationType occupationType;
    private final RealNameAuthenticatedStatus authenticatedStatus;
    //入职时间
    private final Date hiredTime;

    public void setCerStatus(boolean cerStatus) {
        this.cerStatus = cerStatus;
    }

    public void setCerNo(String cerNo){
        this.cerNo = cerNo;
    }

    public void setGradeCerStatus(boolean gradeCerStatus) {
        this.gradeCerStatus = gradeCerStatus;
    }

    //是否持资格证：是/否，判断用户的证书信息是否有“保安资格证”类型的证书信息； 1持证 0未持证
    private boolean cerStatus;
    //是否签订合同：是/否，判断用户的合同信息是否有有效的记录 1签订 0未签订
    private boolean contractStatus;
    private boolean gradeCerStatus;
    //职位
    private final String position;
    //实名备注
    private final String authenticatedResult;
    //性别
    @Enumerated(EnumType.ORDINAL)
    private final Sex sex;
    //出生日期
    private final Date birthdate;
    //民族
    private final String nation;
    //文化程度、
    private final String education;
    //政治面貌
    private final String politicsStatus;
    //户籍类型
    private final String householdType;
    //兵役情况
    private final String militaryStatus;
    //籍贯
    private final String nativePlace;
    //婚姻状况
    private final String maritalStatus;
    //身高（CM）
    private final String stature;
    //紧急联系人姓名
    private final String emergencyContact;
    //紧急联系人电话
    private final String emergencyPhone;
    //驾照等级
    private final String licenseLevel;
    //是否投保
    private final TrueFalseStatus insure;
    //保安资格证号
    private String cerNo;
    // 上级、
    private final String superiorName;
    //合同到期时间
    private Date contractValidDateTo;

    // 转正日期、
    @Temporal(TemporalType.DATE)
    private Date positiveDate;
    // 身份证有效期 开始时间、
    private Date validDateFrom;
    // 身份证有效期 结束时间、
    private Date validDateTo;
    // 身份证住址、
    private String address;
    // 录入系统时间（用户创建时间）、
    private Date createdTime;
    // 上一次核验时间、
    private Date lastCheckedStatusTime;
    // 是否为组织管理员、
    private TrueFalseStatus domainAdmin;
    // 是否为部门管理员、
    private TrueFalseStatus departAdmin = TrueFalseStatus.False;
    // 可管理部门
    private String manageDeparts;

    private String organId;

    /**
     * 员工状态
     */
    private PersonStatus personStatus;

    /**
     * 试用期 数字
     */
    private String probation;

    /**
     * 原定转正日期
     */
    private Date planPositiveDate;
    /**
     * 现住地址
     */
    private LocationValueType placeOfNow;

    private OperatorValueType hiredOperator;

    /**
     * 等级证等级
     */
    private String gradeLevel;

    public void setGradeLevel(String gradeLevel) {
        this.gradeLevel = gradeLevel;
    }

    /**
     * 等级证编号
     */
    private String gradeCerNo;

    private BackgroundScreeningStatus backgroundScreeningStatus;

    public EmployeeDto(String userId,String organName,String id, String name, String telephone,
                       CredentialType credentialType,
                       OccupationType occupationType,
                       String credentialNumber, UserCheckedStatus checkedStatus,
                       UserType userType, RealNameAuthenticatedStatus authenticatedStatus,
                       Date hiredTime,
//                       boolean cerStatus,
//                       boolean contractStatus,
                       String position,String authenticatedResult,Sex sex,Date birthdate,String nation,
                       String education,String politicsStatus,String householdType,String militaryStatus,
                       String nativePlace,String maritalStatus,String stature,String emergencyContact,
                       String emergencyPhone,String licenseLevel,BackgroundScreeningStatus backgroundScreeningStatus,TrueFalseStatus insure,
                       String superiorName,
                       Date positiveDate,
                       Date validDateFrom,
                       Date validDateTo,
                       String address,
                       Date createdTime,
                       TrueFalseStatus domainAdmin,
                       String organId,
                       PersonStatus personStatus,
                       String probation,
                       Date planPositiveDate,
                       LocationValueType placeOfNow,
                       OperatorValueType hiredOperator,
                       Date lastCheckedStatusTime) {
        this.userId = userId;
        this.organName = organName;
        this.id = id;
        this.name = name;
        this.telephone = telephone;
        this.credentialType = credentialType;
        this.credentialNumber = credentialNumber;
        this.checkedStatus = checkedStatus;
        this.userType = userType;
        this.authenticatedStatus = authenticatedStatus;
        this.hiredTime = hiredTime;
        this.occupationType = occupationType;
        this.hiredOperator = hiredOperator;
//        this.cerStatus = cerStatus;
//        this.contractStatus = contractStatus;
        this.position = position;
        this.authenticatedResult = authenticatedResult;
        this.sex = sex;
        this.birthdate = birthdate;
        this.nation = nation;
        this.education = education;
        this.politicsStatus = politicsStatus;
        this.householdType = householdType;
        this.militaryStatus = militaryStatus;
        this.nativePlace = nativePlace;
        this.maritalStatus = maritalStatus;
        this.stature = stature;
        this.emergencyContact = emergencyContact;
        this.emergencyPhone = emergencyPhone;
        this.licenseLevel = licenseLevel;
        this.backgroundScreeningStatus = backgroundScreeningStatus;
        this.insure = insure;
        this.cerNo = cerNo;
        this.superiorName = superiorName;
        this.positiveDate = positiveDate;
        this.validDateFrom = validDateFrom;
        this.validDateTo = validDateTo;
        this.address = address;
        this.createdTime = createdTime;
        this.domainAdmin = domainAdmin;
        this.organId = organId;
        this.personStatus = personStatus;
        this.probation = probation;
        this.planPositiveDate = planPositiveDate;
        this.placeOfNow = placeOfNow;
        this.lastCheckedStatusTime = lastCheckedStatusTime;
    }

    public void assignDepart(String id, String name, Boolean departLeader) {
        this.departId = StrUtil.isEmpty(this.departId) ? id:this.departId+"、"+id;
        this.departName = StrUtil.isEmpty(this.departName) ? name:this.departName+"、"+name;
        if (this.departLeader == null || !this.departLeader) {
            this.departLeader = departLeader;
        }
    }

    public void assignContractStatus(boolean contractStatus,Date contractValidDateTo){
        this.contractStatus = contractStatus;
        this.contractValidDateTo = contractValidDateTo;
    }

    public void assignGradeCerStatus(boolean gradeCerStatus){
        this.gradeCerStatus = gradeCerStatus;
    }

    public void assignAdminDepart(String name) {
        this.manageDeparts = name;
        this.departAdmin = TrueFalseStatus.True;
    }

    public void assignCerNo(String cerNo){
        this.cerNo = cerNo;
        if(StrUtil.isNotEmpty(cerNo)) {
            this.cerStatus = true;
        }
    }

    public void assignGradeCer(String gradeCerNo,String gradeLevel){
        this.gradeCerNo = gradeCerNo;
        this.gradeLevel = gradeLevel;
        if(StrUtil.isNotEmpty(gradeCerNo)) {
            this.gradeCerStatus = true;
        }
    }

}