package com.bcxin.tenant.domain.readers.criterias;

import com.bcxin.Infrastructures.CriteriaAbstract;
import com.bcxin.Infrastructures.enums.*;
import lombok.Getter;

import java.util.Collection;
import java.util.Date;

@Getter
public class EmployeeCriteria extends CriteriaAbstract {
    private final String organizationId;
    private final String keyword;
    private final Date hiredDate;
    private final String organName;
    private final String position;
    //是否持资格证：是/否，判断用户的证书信息是否有“保安资格证”类型的证书信息； 1持证 0未持证
    private String cerStatus;
    //是否签订合同：是/否，判断用户的合同信息是否有有效的记录 1签订 0未签订
    private String contractStatus;
    private String gradeCerStatus;
    //证件核验状态：未提交/已提交/已核验
    private Collection<UserCheckedStatus> checkedStatuses;
    private final Collection<CredentialType> credentialTypes;
    private final Collection<OccupationType> occupationTypes;
    private final Collection<RealNameAuthenticatedStatus> authenticatedStatuses;
    private final Collection<String> departIds;
    private final Collection<BackgroundScreeningStatus> backgroundScreeningStatus;

    private Collection<String> treeCodes;

    private final Collection<Integer> level;
    private final Sex sex;
    private final Integer beginAge;
    private final Integer endAge;

    private Date startDate;
    private Date endDate;

    /**
     * 是否投保
     */
    private TrueFalseStatus insure;

    public EmployeeCriteria(
            int pageIndex, int pageSize,
            String organizationId, String keyword, Date hiredDate, String organName, String position,
            Collection<CredentialType> credentialTypes,
            Collection<OccupationType> occupationTypes,
            Collection<RealNameAuthenticatedStatus> authenticatedStatuses,
            Collection<String> departIds,
            Collection<String> treeCodes,
            String cerStatus, String contractStatus, String gradeCerStatus, Collection<UserCheckedStatus> checkedStatuses,
            Collection<BackgroundScreeningStatus> backgroundScreeningStatus, Collection<Integer> level, Sex sex, Integer beginAge, Integer endAge, Date startDate, Date endDate,
            TrueFalseStatus insure
            ) {
        super(pageIndex,pageSize);

        this.organizationId = organizationId;
        this.keyword = keyword;
        this.hiredDate = hiredDate;
        this.organName = organName;
        this.position = position;
        this.credentialTypes = credentialTypes;
        this.occupationTypes = occupationTypes;
        this.authenticatedStatuses = authenticatedStatuses;
        this.departIds = departIds;
        this.treeCodes = treeCodes;
        this.cerStatus = cerStatus;
        this.contractStatus = contractStatus;
        this.gradeCerStatus = gradeCerStatus;
        this.checkedStatuses = checkedStatuses;
        this.backgroundScreeningStatus = backgroundScreeningStatus;
        this.level = level;
        this.sex = sex;
        this.beginAge = beginAge;
        this.endAge = endAge;
        this.startDate = startDate;
        this.endDate = endDate;
        this.insure = insure;

    }

    public static EmployeeCriteria create(
            int pageIndex, int pageSize,
            String organizationId, String keyword, Date hiredDate, String organName, String position,
                                          Collection<CredentialType> credentialTypes,
                                          Collection<OccupationType> occupationTypes,
                                          Collection<RealNameAuthenticatedStatus> realNameAuthenticatedStatuses,
                                          Collection<String> departIds,
            Collection<String> treeCodes,
            String cerStatus,String contractStatus,String gradeCerStatus,
            Collection<UserCheckedStatus> checkedStatuses, Collection<BackgroundScreeningStatus> backgroundScreeningStatus,Collection<Integer> level,Sex sex,Integer beginAge,Integer endAge,
            Date startDate,Date endDate,
            TrueFalseStatus insure) {
        return new EmployeeCriteria(
                pageIndex, pageSize,
                organizationId, keyword, hiredDate, organName, position, credentialTypes, occupationTypes,
                realNameAuthenticatedStatuses, departIds,treeCodes,cerStatus,contractStatus,
                gradeCerStatus,checkedStatuses,
                backgroundScreeningStatus, level,sex,beginAge,endAge, startDate, endDate,insure);
    }
}
