package com.bcxin.tenant.domain.exceptions;

import com.bcxin.Infrastructures.enums.CredentialType;
import com.bcxin.Infrastructures.exceptions.ArgumentTenantException;
import com.bcxin.Infrastructures.utils.StringUtil;
import lombok.Getter;
import org.springframework.util.CollectionUtils;

import java.io.Serializable;
import java.util.Collection;
import java.util.stream.Collectors;

@Getter
public class EntryEmployeeValidationException extends ArgumentTenantException {
    private final Collection<EntryNotAllowedInfo> notAllowedCompanyInfos;

    public EntryEmployeeValidationException(
            String msg, Collection<EntryNotAllowedInfo> notAllowedCompanyInfos
    ) {
        super(msg);
        this.notAllowedCompanyInfos = notAllowedCompanyInfos;
    }

    @Override
    public String getMessage() {
        if (CollectionUtils.isEmpty(this.notAllowedCompanyInfos)) {
            return super.getMessage();
        }

        return String.format("%s %s", super.getMessage(), this.notAllowedCompanyInfos.stream().map(ii -> ii.toString()).collect(Collectors.joining(",")));
    }

    public String getMatchMessage(String telephone, CredentialType credentialType, String credentialNumber) {
        if (CollectionUtils.isEmpty(this.getNotAllowedCompanyInfos())) {
            return null;
        }

        return this.getNotAllowedCompanyInfos().stream().filter(ii -> {
            return StringUtil.equal(ii.getTelephone(), telephone) && StringUtil.equal(ii.getCredentialNumber(), credentialNumber) &&
                    credentialType == ii.getCredentialType();
        }).map(ii -> ii.getMessage()).collect(Collectors.joining(";"));
    }

    public static EntryEmployeeValidationException create(String msg, Collection<EntryNotAllowedInfo> notAllowedCompanyInfos) {
        return new EntryEmployeeValidationException(msg, notAllowedCompanyInfos);
    }

    @Getter
    public static class EntryNotAllowedInfo implements Serializable {
        private final String message;
        private final String name;

        private final String telephone;
        private final CredentialType credentialType;
        private final String credentialNumber;

        public EntryNotAllowedInfo(String name, String message,
                                   String telephone, CredentialType credentialType, String credentialNumber) {
            this.message = message;
            this.name = name;
            this.telephone = telephone;
            this.credentialType = credentialType;
            this.credentialNumber = credentialNumber;
        }

        public static EntryNotAllowedInfo create(String name, String message,
                                                 String telephone, CredentialType credentialType, String credentialNumber) {
            return new EntryNotAllowedInfo(name, message, telephone, credentialType, credentialNumber);
        }

        @Override
        public String toString() {
            return this.getMessage();
        }
    }
}
