package com.bcxin.tenant.domain.events.handlers;

import com.bcxin.Infrastructures.enums.CredentialType;
import com.bcxin.Infrastructures.events.handlers.DomainEventHandlerAbstract;
import com.bcxin.Infrastructures.exceptions.ArgumentTenantException;
import com.bcxin.Infrastructures.validations.CredentialValidator;
import com.bcxin.tenant.domain.entities.EmployeeEntity;
import com.bcxin.tenant.domain.events.TenantCredentialChangedValidateEvent;
import com.bcxin.tenant.domain.readers.TenantDbReader;
import com.bcxin.tenant.domain.repositories.EmployeeRepository;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

import java.util.Collection;

/**
 * 校验证件类型是否为有效
 */
@Component
public class TenantCredentialChangedEvent_EmployeeValidatorHandler extends DomainEventHandlerAbstract<TenantCredentialChangedValidateEvent> {
    private final EmployeeRepository employeeRepository;

    private final TenantDbReader tenantDbReader;

    public TenantCredentialChangedEvent_EmployeeValidatorHandler(EmployeeRepository employeeRepository,TenantDbReader tenantDbReader) {
        this.employeeRepository = employeeRepository;
        this.tenantDbReader = tenantDbReader;
    }

    @Override
    protected void execute(TenantCredentialChangedValidateEvent event) {
        if (event.getData() == null) {
            throw new ArgumentTenantException("证件类型不能为空");
        }

        if (event.getData() == CredentialType.IdCard) {
            if (!StringUtils.hasLength(event.getNumber())) {
                throw new ArgumentTenantException("证件编号不能为空");
            }

            if (!CredentialValidator.validate(event.getData(), event.getNumber())) {
                throw new ArgumentTenantException(String.format("证件编号(%s)不符合要求",event.getNumber()));
            }
        }

        Collection<EmployeeEntity> employeeEntities = this.employeeRepository.getSecurityGuardsByTenantUserId(event.getTenantUserId());
        if (employeeEntities.size() > 0) {
            if (event.getData() != CredentialType.IdCard) {
                throw new ArgumentTenantException("保安员只能提交身份证件信息");
            }

            int age = CredentialValidator.getAge(event.getNumber());

            if(!event.isFromMobile()) {
                if (age < 18) {
                    throw new ArgumentTenantException("保安员必须不小于18岁");
                }
            }

            String areaCode = "";

            for (EmployeeEntity employeeEntity : employeeEntities) {
                areaCode = employeeEntity.getOrganization().getSuperviseRegionCode();
                if(!event.isFromMobile()) {
                    employeeEntity.getOccupationType().validate(CredentialType.IdCard,event.getNumber(),areaCode,employeeEntity.getOrganization().getInstitutionalCode());
                    /*
                    if (areaCode.startsWith("11")) {
//                1404 注释: 北京地区保安员入职，年龄校验调整，限制男18~59岁（含）、女18~54岁（含）
                        if (IdcardUtil.getGenderByIdCard(event.getNumber()) == 0) {
                            //1701 北京地区入职年龄限制调整为女性最高49岁，男性不变
                            if (age > 49) {
                                throw new ArgumentTenantException("入职女保安员, 年龄必须小于50岁");
                            }
                        } else if (age > 59) {
                            throw new ArgumentTenantException("入职男保安员, 年龄必须小于60岁");
                        }
                    }

                     */
                }
            }
        }
    }
}
