package com.bcxin.tenant.domain.events.handlers;

import com.bcxin.Infrastructures.components.JsonProvider;
import com.bcxin.Infrastructures.events.handlers.DomainEventHandlerAbstract;
import com.bcxin.tenant.domain.enums.EventAction;
import com.bcxin.tenant.domain.events.DepartmentUpdatedEvent;
import com.bcxin.tenant.domain.repositories.EmployeeRepository;
import com.bcxin.tenant.domain.services.TenantEventService;
import com.bcxin.tenant.domain.services.commands.CreateTenantEventCommand;
import org.springframework.stereotype.Component;

@Component
public class DepartmentUpdatedEvent_Handler extends DomainEventHandlerAbstract<DepartmentUpdatedEvent> {
    private final TenantEventService eventService;
    private final JsonProvider jsonProvider;
    private final EmployeeRepository employeeRepository;

    public DepartmentUpdatedEvent_Handler(TenantEventService eventService, JsonProvider jsonProvider,EmployeeRepository employeeRepository) {
        this.eventService = eventService;
        this.jsonProvider = jsonProvider;
        this.employeeRepository = employeeRepository;
    }

    @Override
    protected void execute(DepartmentUpdatedEvent event) {
        this.eventService.create(CreateTenantEventCommand.create(EventAction.DepartmentEdited, event.getData().getId(), event.getData().getName()));
        this.employeeRepository.updateRelativeDepartmentIndexCodeByIds(event.getData().getId(),event.getData().getIndexTree());
    }
}
