package com.bcxin.tenant.domain.events;

import com.bcxin.Infrastructures.events.DomainEventAbstract;
import lombok.Getter;

@Getter
public class TenantUserTelephoneChangedEvent extends DomainEventAbstract<String> {
    private final String id;
    private final String telephone;
    private final String oldPhone;
    private final String name;
    private final String idNum;

    /**
     * Create a new {@code ApplicationEvent}.
     *
     * @param telephone
     * @param id
     * @param name
     */
    public TenantUserTelephoneChangedEvent(String id, String telephone, String oldPhone, String name,String idNum) {
        super(id);
        this.id = id;
        this.telephone = telephone;
        this.oldPhone = oldPhone;
        this.name = name;
        this.idNum = idNum;
    }

    public static TenantUserTelephoneChangedEvent create(String id, String telephone, String oldPhone, String name,String idNum) {
        return new TenantUserTelephoneChangedEvent(id, telephone, oldPhone, name,idNum);
    }
}
