package com.bcxin.tenant.domain.events;

import com.bcxin.Infrastructures.events.DomainEventAbstract;
import com.bcxin.tenant.domain.entities.valueTypes.LocationValueType;
import com.bcxin.Infrastructures.enums.ApprovedStatus;
import lombok.Getter;

@Getter
public class OrganizationApprovedChangedEvent  extends DomainEventAbstract<String> {
    private final String organId;
    private final LocationValueType placeOfRegister;
    private final LocationValueType placeOfBusiness;
    private final ApprovedStatus status;
    private final String superviseRegionCode;
    /**
     * 机构类型:
     * 自行招用保安员单位,保安服务公司,省级保安协会,其他等
     */
    private final String institutionalCode;

    public OrganizationApprovedChangedEvent(String organId,ApprovedStatus status, LocationValueType placeOfRegister,
                                            LocationValueType placeOfBusiness,
                                            String institutionalCode,String superviseRegionCode) {
        super(organId);
        this.organId = organId;
        this.status = status;
        this.placeOfRegister = placeOfRegister;
        this.placeOfBusiness = placeOfBusiness;
        this.institutionalCode = institutionalCode;
        this.superviseRegionCode=superviseRegionCode;
    }

    /**
     * 注册地的省份+城市
     * 结合结构类型; 用于获取应用包
     *
     * @return
     */
    public String getRegisterProvinceCity() {
        if (placeOfRegister == null) {
            return null;
        }

        return String.format("%s%s", placeOfRegister.getProvince(), placeOfRegister.getCity());
    }

    public static OrganizationApprovedChangedEvent create(String organId,
                                                          ApprovedStatus status,
                                                          LocationValueType placeOfRegister,
                                                          LocationValueType placeOfBusiness,
                                                          String institutionalCode,String superviseRegionCode) {
        return new OrganizationApprovedChangedEvent(organId, status, placeOfRegister, placeOfBusiness, institutionalCode,superviseRegionCode);
    }
}
