package com.bcxin.tenant.domain.events;

import com.bcxin.Infrastructures.enums.MasterSlaveType;
import com.bcxin.Infrastructures.enums.Sex;
import com.bcxin.Infrastructures.events.DomainEventAbstract;
import com.bcxin.tenant.domain.entities.EmployeeEntity;
import com.bcxin.Infrastructures.enums.CredentialType;
import lombok.Getter;

import java.util.Date;

/**
 * 不要操作跟职员相关的记录, 这边将会采用tenant_users.id与org.id组合来生成职员Id
 */
@Getter
public class EmployeeBeforeCreatedEvent extends DomainEventAbstract<EmployeeEntity> {
    private final String name;
    private final String telephone;
    private final String password;
    private final CredentialType credentialType;
    private final String credentialNumber;
    private final boolean ensureExistsUser;
    private final MasterSlaveType masterSlaveType;
    private final Sex sex;
    private final Date birthdate;
    private final String nation;
    private final String education;
    private final String politicsStatus;
    private final String militaryStatus;
    private final String maritalStatus;
    private final String emergencyContact;
    private final String emergencyPhone;
    private final String address;
    private final String householdType;

    public EmployeeBeforeCreatedEvent(EmployeeEntity employee,
                                      String name, String telephone,
                                      String password,
                                      CredentialType credentialType,
                                      String credentialNumber,
                                      MasterSlaveType masterSlaveType,
                                      boolean ensureExistsUser,
                                      Sex sex,
                                      Date birthdate,
                                      String nation,
                                      String education,
                                      String politicsStatus,
                                      String militaryStatus,
                                      String maritalStatus,
                                      String emergencyContact,
                                      String emergencyPhone,
                                      String address,
                                      String householdType) {
        super(employee);

        this.name = name;
        this.telephone = telephone;
        this.password = password;
        this.credentialType = credentialType;
        this.credentialNumber = credentialNumber;
        this.ensureExistsUser = ensureExistsUser;
        this.masterSlaveType = masterSlaveType;
        this.sex = sex;
        this.birthdate = birthdate;
        this.nation = nation;
        this.education = education;
        this.politicsStatus = politicsStatus;
        this.militaryStatus = militaryStatus;
        this.maritalStatus = maritalStatus;
        this.emergencyContact = emergencyContact;
        this.emergencyPhone = emergencyPhone;
        this.address = address;
        this.householdType = householdType;
    }


    public static EmployeeBeforeCreatedEvent create(EmployeeEntity employee,
                                                    String name, String telephone,
                                                    String password,
                                                    CredentialType credentialType,
                                                    String credentialNumber,
                                                    MasterSlaveType masterSlaveType,
                                                    boolean ensureExistsUser,
                                                    Sex sex,
                                                    Date birthdate) {
        return new EmployeeBeforeCreatedEvent(employee, name, telephone, password,credentialType, credentialNumber,
                masterSlaveType, ensureExistsUser, sex, birthdate, null, null, null,
                null, null, null, null, null, null);
    }

    public static EmployeeBeforeCreatedEvent create(EmployeeEntity employee,
                                                    String name, String telephone,
                                                    String password,
                                                    CredentialType credentialType,
                                                    String credentialNumber,
                                                    MasterSlaveType masterSlaveType,
                                                    boolean ensureExistsUser,
                                                    Sex sex,
                                                    Date birthdate,
                                                    String nation,
                                                    String education,
                                                    String politicsStatus,
                                                    String militaryStatus,
                                                    String maritalStatus,
                                                    String emergencyContact,
                                                    String emergencyPhone,
                                                    String address,
                                                    String householdType) {
        return new EmployeeBeforeCreatedEvent(employee, name, telephone, password,credentialType, credentialNumber,
                masterSlaveType, ensureExistsUser, sex, birthdate, nation, education, politicsStatus, militaryStatus,
                maritalStatus, emergencyContact, emergencyPhone, address, householdType);
    }
}