package com.bcxin.tenant.domain.events;
import com.bcxin.Infrastructures.events.DomainEventAbstract;
import com.bcxin.tenant.domain.entities.EmployeeEntity;
import lombok.Getter;

import javax.persistence.Transient;

@Getter
public class EmployeeAfterCreatedEvent extends DomainEventAbstract<EmployeeEntity> {

    private final String telephone;

    private final boolean usePhone;

    /**
     * Create a new {@code ApplicationEvent}.
     *
     * @param data
     * @param telephone
     */
    public EmployeeAfterCreatedEvent(EmployeeEntity data, String telephone,boolean usePhone) {
        super(data);
        this.telephone = telephone;
        this.usePhone = usePhone;
    }

    public static EmployeeAfterCreatedEvent create(EmployeeEntity data, String telephone,boolean usePhone) {
        return new EmployeeAfterCreatedEvent(data, telephone,usePhone);
    }
}
