package com.bcxin.tenant.domain.entities;

import com.bcxin.Infrastructures.entities.EntityAbstract;
import com.bcxin.Infrastructures.entities.IAggregate;
import com.bcxin.Infrastructures.enums.EmploymentStatus;
import com.bcxin.tenant.domain.DomainConstraint;
import lombok.AccessLevel;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;
import java.sql.Timestamp;
import java.time.Instant;

/**
 * 用来保证业务的唯一性
 */
@Getter
@Setter(AccessLevel.PROTECTED)
@Table(name = "tenant_unique_data_constraints")
@Entity
public class UniqueDataConstraintEntity extends EntityAbstract implements IAggregate {
    @Id
    @Column(length = 255)
    private String id;

    @Id
    @Column(length = 255, nullable = false)
    private String category;

    private Timestamp createdTime;

    protected UniqueDataConstraintEntity() {
        this.createdTime = Timestamp.from(Instant.now());
    }

    public static UniqueDataConstraintEntity create(String id, String category) {
        UniqueDataConstraintEntity data = new UniqueDataConstraintEntity();
        data.setId(id);
        data.setCategory(category);

        return data;
    }

    public static String generateId(String combineId) {
        return String.format("%s_%s", DomainConstraint.PK_UNIQUE_DATA_CONSTRAINT_COMBINE_ID_PREFIX, combineId);
    }

    public static String getNewEmployeeCombinedId(String tenantUserId) {
        return String.format("%s+%s", tenantUserId, EmploymentStatus.OnJob);
    }
}
