package com.bcxin.tenant.domain.entities;

import cn.hutool.core.util.StrUtil;
import com.bcxin.Infrastructures.enums.CerType;
import com.bcxin.Infrastructures.enums.CredentialType;
import com.bcxin.Infrastructures.enums.GradeLevel;
import lombok.AccessLevel;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.*;
import java.util.Date;

/**
 * 证件类型
 */
@Getter
@Setter(AccessLevel.PROTECTED)
@Table(name = "tenant_user_credential_details")
@Entity
public class TenantUserCredentialDetailsEntity {
    @Id
    private String id;

    @Column(name = "active")
    private Boolean active;

    @Column(name = "areacode")
    private String areaCode;
    /**
     * 证件姓名
     */
    @Column(name = "xm",length = 50,nullable = false)
    private String name;

    /**
     * 证书类型
     */
    @Column(name = "certificatetype", nullable = false)
    private String certificateType;

    @Column(name = "fzrq")
    private Date cerDate;

    @Transient
    private CerType cerType;

    /**
     * 证书等级
     */
    @Column(name = "appraisalgrade", nullable = false)
    private String appraisalGrade;

    @Transient
    private GradeLevel gradeLevel;

    /**
     * 证书编号
     */
    @Column(name = "zsbh")
    private String cerNo;

    /**
     * 发证机关
     */
    @Column(name = "fzjgmc")
    private String orgName;


    /**
     * 用户id
     */
    @Column(name = "tenant_user_id")
    private String tenantUserId;

    /**
     * 身份证号
     */
    @Column(name = "idnum")
    private String idnum;

    /**
     * 状态
     */
    @Column(name = "state")
    private String state;
    public CerType getCerType() {
        if(StrUtil.isNotEmpty(this.certificateType)) {
            return CerType.coventTypeValue(this.certificateType);
        }
        return null;
    }

    public GradeLevel getGradeLevel() {
        if(StrUtil.isNotEmpty(this.appraisalGrade)) {
            return GradeLevel.coventTypeValue(this.appraisalGrade);
        }
        return null;
    }

    public String getCerTypeName(){
        CerType cerType = getCerType();
        if(cerType != null){
            if(cerType.equals(CerType.Grade)){
                GradeLevel gradeLevel = getGradeLevel();
                if(gradeLevel != null){
                    return cerType.getTypeName()+"-"+gradeLevel.getTypeName();
                }
            }
            return cerType.getTypeName();
        }
        return null;
    }
}
