package com.bcxin.tenant.domain.entities;

import com.bcxin.Infrastructures.entities.EntityAbstract;
import com.bcxin.Infrastructures.entities.IAggregate;
import lombok.AccessLevel;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;

/**
 * 省市区编码
 */
@Getter
@Setter(AccessLevel.PROTECTED)
@Table(name = "sys_region")
@Entity
public class RegionEntity extends EntityAbstract implements IAggregate {

    /**
     * 区域ID
     */
    @Id
    private String id;

    /**
     * 区域名称
     */
    @Column(name = "region_name",nullable = false, length = 50)
    private String regionName;

    /**
     * 区域全称
     */
    @Column(name = "region_full_name",length = 100)
    private String regionFullName;

    /**
     * 区域级别
     */
    @Column(name = "region_level",length = 6)
    private String regionLevel;

    /**
     * 地区首字母
     */
    @Column(name = "first_letter",length = 1)
    private String firstLetter;

    /**
     * 备注
     */
    @Column(length = 200)
    private String remark;

    /**
     * 排序
     */
    @Column(nullable = false)
    private int seq;

    /**
     * 上级区域ID
     */
    @Column(name = "parent_id")
    private String parentId;

}






