package com.bcxin.tenant.domain.entities;

import com.bcxin.Infrastructures.entities.EntityAbstract;
import com.bcxin.Infrastructures.entities.IAggregate;
import com.bcxin.Infrastructures.enums.ActionType;
import com.bcxin.Infrastructures.enums.InviteType;
import lombok.AccessLevel;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.*;
import java.sql.Timestamp;

@Getter
@Setter(AccessLevel.PROTECTED)
@Table(name = "tenant_organization_relationship_action_histories")
@Entity
public class OrganizationRelationshipActionHistoriesEntity extends EntityAbstract implements IAggregate {

    @GeneratedValue(strategy = GenerationType.IDENTITY)
    @Id
    @Column(name = "id",nullable = false)
    private long id;


    @Column(name = "relationship_id",nullable = false)
    private long relationshipId;

    @Enumerated(EnumType.ORDINAL)
    @Column(name = "action_type",length = 3,nullable = false)
    private ActionType actionType;

    @Column(name = "note",nullable = false)
    private String note;

    @Column(name = "organization_id",length = 50,nullable = false)
    private String organizationId;

    @Column(name = "created_time",nullable = false)
    private Timestamp createTime;

    @Column(name = "creator_id",length = 50,nullable = false)
    private String creatorId;

    @Enumerated(EnumType.ORDINAL)
    @Column(name = "invite_type",length = 3,nullable = false)
    private InviteType inviteType;

    public OrganizationRelationshipActionHistoriesEntity() {
        this.setCreateTime(new Timestamp(System.currentTimeMillis()));
    }

    public OrganizationRelationshipActionHistoriesEntity(long relationshipId, ActionType actionType, String note, String organizationId, String creatorId, InviteType inviteType) {
        this();
        this.relationshipId = relationshipId;
        this.actionType = actionType;
        this.note = note;
        this.organizationId = organizationId;
        this.creatorId = creatorId;
        this.inviteType = inviteType;
    }
    public static OrganizationRelationshipActionHistoriesEntity create(long relationshipId, ActionType actionType, String note,String organizationId, String creatorId, InviteType inviteType) {
        return new OrganizationRelationshipActionHistoriesEntity(relationshipId, actionType, note, organizationId, creatorId, inviteType);
    }
}
