package com.bcxin.tenant.domain.entities;

import com.bcxin.Infrastructures.entities.EntityAbstract;
import com.bcxin.Infrastructures.entities.IAggregate;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.persistence.*;
import java.util.Date;

/**
 * description：操作日志表
 * author：linchunpeng
 * date：2023/12/13
 */
@EqualsAndHashCode(callSuper = true)
@Table(name = "t_operate_log")
@Entity
@Data
public class OperateLogEntity extends EntityAbstract implements IAggregate {

    /**
     * 主键
     */
    @Id
    @Column(name = "id")
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    private Long id;

    /**
     * 用户id
     */
    @Column(name = "tenant_user_id")
    private String tenantUserId;

    /**
     * 账号
     */
    @Column(name = "user_name")
    private String userName;

    /**
     * 姓名
     */
    @Column(name = "real_name")
    private String realName;

    /**
     * 操作类型：1登录
     */
    @Column(name = "operate_type")
    private Integer operateType;

    /**
     * 操作时间
     */
    @Column(name = "operate_time")
    private Date operateTime;

    /**
     * 操作内容
     */
    @Column(name = "operate_content")
    private String operateContent;

    /**
     * 操作结果
     */
    @Column(name = "operate_result")
    private String operateResult;

    /**
     * IP地址
     */
    @Column(name = "ip_address")
    private String ipAddress;

}
