package com.bcxin.tenant.domain.entities;

import com.bcxin.Infrastructures.entities.EntityAbstract;
import com.bcxin.Infrastructures.entities.IAggregate;
import com.bcxin.Infrastructures.enums.InviteType;
import lombok.AccessLevel;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.*;
import java.sql.Timestamp;

@Getter
@Setter(AccessLevel.PROTECTED)
@Table(name = "invite_organization_relationships")
@Entity
public class InviteOrganizationRelationshipEntity extends EntityAbstract implements IAggregate {
    @Id
    @Column(nullable = false)
    private long id;

    @Column(name = "code",length = 30,nullable = false)
    private String code;

    @Column(name = "organization_id",length = 50,nullable = false)
    private String organizationId;

    @Enumerated(EnumType.ORDINAL)
    @Column(name = "invite_type",length = 3,nullable = false)
    private InviteType inviteType;

    @Column(name = "content",length = 2000)
    private String content;

    @Column(name = "created_time",nullable = false)
    private Timestamp createdTime;

    @Column(name = "creator_id",length = 50,nullable = false)
    private String creatorId;

    public InviteOrganizationRelationshipEntity() {
        this.setCreatedTime(new Timestamp(System.currentTimeMillis()));
    }
    public InviteOrganizationRelationshipEntity(String code, String organizationId, InviteType inviteType, String content, String creatorId) {
        this();
        this.code = code;
        this.organizationId = organizationId;
        this.inviteType = inviteType;
        this.content = content;
        this.creatorId = creatorId;
    }

    public static InviteOrganizationRelationshipEntity create(String code, String organizationId, InviteType inviteType, String content, String creatorId) {
        return new InviteOrganizationRelationshipEntity(code, organizationId, inviteType, content, creatorId);
    }
}
