package com.bcxin.tenant.domain.configs;

import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

/**
 * 单点登录配置
 * @author linqinglin
 * @date 2021/10/20 0020 16:00
 */
@Component
@ConfigurationProperties(prefix = "sso")
public class SSOConfig {

    /** 开关 true开 false关 */
    private static Boolean useSwitch=false;

    /** 是否使用系统自带的角色权限 */
    private static Boolean selfAuth=true;

    /**
     * AES加密、
     * 广西南宁单点登录 解密Key
     */
    private static String key;

    /**
     * 广西南宁单点登录的用户id
     * 或者 北京自然人单点登录的用户id
     */
    private static String clientId;

    /**
     * 广西南宁单点登录的密钥
     * 或者 北京自然人单点登录的密钥
     */
    private static String clientSecret;

    /**
     * 广西南宁单点登录的 接口地址
     * 或者 北京自然人单点登录的接口地址
     */
    private static String url;

    /**
     * V5后台接口地址
     * 广西南宁单点登录用到，生成角色权限时用到
     */
    private static String v5Url;
    /**
     * 系统编码 （子系统顶级菜单id）
     * 广西南宁单点登录用到
     */
    private static String zxtqxgw;

    /**
     * 广西南宁 的监管机构组织id
     * 或者 北京单点登录的 自然人默认加入组织id
     */
    private static String domainId;

    /**
     * 北京自然人单点登录的 自然人默认加入部门id
     */
    private static String departId;

    /**
     * 北京自然人单点登录的 自然人默认加入角色id
     */
    private static String roleId;

    /**
     * 北京法人单点登录的
     */
    private static String legalRoleId;

    /**
     * 密码前缀（有值才设置密码）
     */
    private static String passPrefix;

    public static Boolean getUseSwitch() {
        return useSwitch;
    }

    public void setUseSwitch(Boolean useSwitch) {
        SSOConfig.useSwitch = useSwitch;
    }

    public static Boolean getSelfAuth() {
        return selfAuth;
    }

    public void setSelfAuth(Boolean selfAuth) {
        SSOConfig.selfAuth = selfAuth;
    }

    public static String getKey() {
        return key;
    }

    public void setKey(String key) {
        SSOConfig.key = key;
    }

    public static String getClientId() {
        return clientId;
    }

    public void setClientId(String clientId) {
        SSOConfig.clientId = clientId;
    }

    public static String getClientSecret() {
        return clientSecret;
    }

    public void setClientSecret(String clientSecret) {
        SSOConfig.clientSecret = clientSecret;
    }

    public static String getUrl() {
        return url;
    }

    public void setUrl(String url) {
        SSOConfig.url = url;
    }


    public static String getV5Url() {
        return v5Url;
    }

    public void setV5Url(String v5Url) {
        SSOConfig.v5Url = v5Url;
    }

    public static String getZxtqxgw() {
        return zxtqxgw;
    }

    public void setZxtqxgw(String zxtqxgw) {
        SSOConfig.zxtqxgw = zxtqxgw;
    }


    public static String getDomainId() {
        return domainId;
    }

    public void setDomainId(String domainId) {
        SSOConfig.domainId = domainId;
    }

    public static String getDepartId() {
        return departId;
    }

    public void setDepartId(String departId) {
        SSOConfig.departId = departId;
    }

    public static String getRoleId() {
        return roleId;
    }

    public void setRoleId(String roleId) {
        SSOConfig.roleId = roleId;
    }

    public static String getLegalRoleId() {
        return legalRoleId;
    }

    public void setLegalRoleId(String legalRoleId) {
        SSOConfig.legalRoleId = legalRoleId;
    }

    public static String getPassPrefix() {
        return passPrefix;
    }

    public static void setPassPrefix(String passPrefix) {
        SSOConfig.passPrefix = passPrefix;
    }

    public static String getRedirectUrl() {
        return url + "open/login/goUserLogin?client_id="+clientId+"&response_type=code&scope=user_info&redirect_uri=";
    }
}
