package com.bcxin.tenant.domain.configs;

import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

@Data
@ConfigurationProperties(prefix = "env")
@Component
public class EnvConfig {
    private boolean requiredPhoneAsLoginName = false;
    private int allowedmonthGisChanges = 2;

    /**
     * 密码前缀（有值才设置密码）
     */
    private String passPrefix;

    /**
     * 注册的sms短信模板编码
     */
    private String registerSmsTemplateCode;

    /**
     * 审核审批通过的短信
     */
    private String orgApprovedTemplateCode;
}
