package com.bcxin.tenant.domain.repository.impls;

import com.bcxin.tenant.domain.entities.SuperviseDepartmentEntity;
import com.bcxin.tenant.domain.repositories.SuperviseDepartmentRepository;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;

import java.util.List;

public interface SuperviseDepartmentJpaRepository extends SuperviseDepartmentRepository, JpaRepository<SuperviseDepartmentEntity, Long> {


    @Query("select t from SuperviseDepartmentEntity t where t.status = '启用' and t.regionId like CONCAT(:regionStartWith,'%') ")
    List<SuperviseDepartmentEntity> findByRegionIdStartWith(@Param("regionStartWith") String regionStartWith);

}
