package com.bcxin.tenant.domain.repository.impls;

import com.bcxin.tenant.domain.entities.RegionEntity;
import com.bcxin.tenant.domain.repositories.RegionRepository;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;

import java.util.List;

public interface RegionJpaRepository extends RegionRepository, JpaRepository<RegionEntity,String> {

    @Query("select r from RegionEntity r where r.parentId=?1 order by seq")
    List<RegionEntity> findByParentId(String parentId);

    @Query("select r from RegionEntity r order by parentId,seq")
    List<RegionEntity> findAll();

}
