package com.bcxin.tenant.domain.repository.impls;

import com.bcxin.Infrastructures.enums.TrueFalseStatus;
import com.bcxin.tenant.domain.entities.EmployeeEntity;
import com.bcxin.tenant.domain.repositories.EmployeeRepository;
import com.bcxin.tenant.domain.repositories.dtos.OrganizationAdminiInfoDto;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.transaction.annotation.Transactional;

import java.util.Collection;
import java.util.List;

public interface EmployeeJpaRepository extends EmployeeRepository, JpaRepository<EmployeeEntity,String> {

    @Query("select e from EmployeeEntity e where e.organization.id=?1 and e.id in (?2)")
    Collection<EmployeeEntity> getByIds(String organizationId, Collection<String> ids);

    @Query("select count(e) from EmployeeEntity e where e.organization.id=?1 and e.superior.id=?2 ")
    long countChildById(String organizationId, String id);

    @Modifying
    @Query("update EmployeeEntity set superior.id=?3 where organization.id=?1 and superior.id=?2")
    int replaceSuperior(String organizationId, String originalId, String newId);

    @Query("select e from EmployeeEntity e where e.organization.id=?1 and e.id=?2")
    EmployeeEntity getByOrganIdAndId(String organizationId, String id);

    @Query("select u from EmployeeEntity u join u.tenantUser t where u.organization.id=?1 and t.selectedCredential.number in (?2)")
    Collection<EmployeeEntity> getByIdNums(String organizationId, Collection<String> idNums);

    @Query("select u from EmployeeEntity u join u.tenantUser t where u.organization.id=?1 and t.telephone in (?2)")
    Collection<EmployeeEntity> getByTelephones(String organizationId, Collection<String> telephones);

    @Query("select u from EmployeeEntity u join u.tenantUser t where t.selectedCredential.number in (?1)")
    List<EmployeeEntity> getAllByIdNums(Collection<String> idNums);

    @Query("select u from EmployeeEntity u join u.tenantUser t where t.telephone in (?1)")
    List<EmployeeEntity> getAllByTelephones(Collection<String> telephones);

    @Query("select u from EmployeeEntity u join u.tenantUser t where u.occupationType=com.bcxin.Infrastructures.enums.OccupationType.SecurityGuard and t.selectedCredential.number in (?1) and u.status <> 1")
    List<EmployeeEntity> getSecurityGuardByIdNums(Collection<String> idNums);

    @Query("select u from EmployeeEntity u join u.tenantUser t where u.organization.id=?1 and t.telephone=?2")
    EmployeeEntity getByTelephone(String organizationId, String telephone);

    @Query("select u from EmployeeEntity u join u.tenantUser t where u.organization.id=?1 and t.selectedCredential.number=?2")
    EmployeeEntity getByIdNum(String organizationId, String idNum);

    @Query("select e from EmployeeEntity e where e.tenantUser.id=?1 and e.occupationType=com.bcxin.Infrastructures.enums.OccupationType.SecurityGuard")
    Collection<EmployeeEntity> getSecurityGuardsByTenantUserId(String tenantUserId);

    @Query("select e from EmployeeEntity e where e.organization.id=?1 and e.status <> com.bcxin.Infrastructures.enums.EmploymentStatus.OffJob and position in ('系统管理员','总经理','副总经理')")
    Collection<EmployeeEntity> getRegisterEmployeeByOrganId(String organizationId);

    @Query("select e from EmployeeEntity e where e.status<>com.bcxin.Infrastructures.enums.EmploymentStatus.OffJob and e.organization.id=?1")
    Collection<EmployeeEntity> getAllByOrganId(String organizationId);


    @Query("select e.id from EmployeeEntity e where e.insure = com.bcxin.Infrastructures.enums.TrueFalseStatus.False and e.id in (?1)")
    Collection<String> queryIdByNotIsSure(Collection<String> ids);

    @Query("select e.id from EmployeeEntity e where e.insure = com.bcxin.Infrastructures.enums.TrueFalseStatus.True  and e.id not in (?1)")
    Collection<String> queryIdByFailureIsSure(Collection<String> ids);

    @Query("select e.id from EmployeeEntity e where e.insure = com.bcxin.Infrastructures.enums.TrueFalseStatus.True  and e.id in (?1)")
    Collection<String> queryIdBySuccessIsSure(Collection<String> ids);

    @Modifying
    @Transactional
    @Query(value = "update EmployeeEntity e set e.insure = ?2 where e.id in (?1)")
    void updateIsSureStatus(Collection<String> ids, TrueFalseStatus status);


    @Modifying
    @Query(value = "update DepartmentEmployeeRelationEntity e set e.departmentIndexTree = ?2 where e.department.id = ?1")
    void updateRelativeDepartmentIndexCodeByIds(String departId, String newIndexTreeCode);

    @Query("select e.id from EmployeeEntity e where e.status <> com.bcxin.Infrastructures.enums.EmploymentStatus.OffJob " +
            " and e.id in (select de.employee.id from DepartmentEmployeeRelationEntity de where de.departmentIndexTree like ?1)")
    List<String> findIdListByDepartmentIndexTree(String departmentIndexTree);

    @Query("select e from EmployeeEntity e where e.status <> com.bcxin.Infrastructures.enums.EmploymentStatus.OffJob " +
            " and e.organization.id=?1 and e.domainAdmin = com.bcxin.Infrastructures.enums.TrueFalseStatus.True ")
    List<EmployeeEntity> getAdminByOrganId(String organizationId);

    @Query("select 1 from EmployeeEntity e where e.organization.id=?1 and e.tenantUser.id=?2 ")
    boolean checkIfExists(String organizationId, String tenantUserId);

    @Query("select e.id from EmployeeEntity e where e.organization.id=?1 and e.tenantUser.id=?2 ")
    String getByOrgIdAndUserId(String organizationId, String tenantUserId);

    @Query("select e from EmployeeEntity e where e.organization.id=?1 and exists (select 1 from TenantUserCredentialsEntity c where c.number=?2 and c.tenantUser.id=e.tenantUser.id )")
    EmployeeEntity getIdByOrgIdAndIdCard(String organizationId, String idCardNo);

    @Query("select e.tenantUser.name from EmployeeEntity e where e.status = com.bcxin.Infrastructures.enums.EmploymentStatus.OnJob " +
            " and e.superior.id in (?1)")
    List<String> findJuniorNameListBySuperiorId(Collection<String> superiorId);
}
