package com.bcxin.tenant.domain.repository.impls;

import com.bcxin.tenant.domain.entities.DepartmentEntity;
import com.bcxin.tenant.domain.repositories.DepartmentRepository;
import com.bcxin.tenant.domain.repositories.dtos.DepartmentDto;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;

import java.util.Collection;
import java.util.List;

public interface DepartmentJpaRepository extends DepartmentRepository, JpaRepository<DepartmentEntity,String> {

    @Query("select new com.bcxin.tenant.domain.repositories.dtos.DepartmentDto(d.id,d.code,d.name,d.parent.id,d.level,-1l, d.displayOrder,d.permissionType,d.permissionConfig,d.indexTree) from DepartmentEntity d where d.organization.id=?1 and d.parent.id=?2  and d.deleted = false")
    Collection<DepartmentDto> getDtoByOrganIdAndParentId(String organId, String parentId);

    @Query("select new com.bcxin.tenant.domain.repositories.dtos.DepartmentDto(d.id,d.code,d.name,d.parent.id,d.level,-1l,d.displayOrder,d.permissionType,d.permissionConfig,d.indexTree) from DepartmentEntity d where d.organization.id=?1 and d.id=?2")
    DepartmentDto getDtoByOrganIdAndId(String organId, String id);

    @Query("select new com.bcxin.tenant.domain.repositories.dtos.DepartmentDto(d.id,d.code,d.name,d.parent.id,d.level,-1l,d.displayOrder,d.permissionType,d.permissionConfig,d.indexTree) from DepartmentEntity d where d.organization.id=?1 and d.parent is null and d.deleted = false")
    Collection<DepartmentDto> getRootDtoByOrganId(String organId);

    @Query("select new com.bcxin.tenant.domain.repositories.dtos.DepartmentDto(d.id,d.code,d.name,d.parent.id,d.level,-1l,d.displayOrder,d.permissionType,d.permissionConfig,d.indexTree) from DepartmentEntity d where d.organization.id=?1 and d.deleted = false")
    Collection<DepartmentDto> getDtosByOrganId(String organId);

    @Query("select d from DepartmentEntity d where d.organization.id=?1 and d.parent is null and d.deleted = false")
    Collection<DepartmentEntity> getRootsByOrganId(String organId);

    @Query("select d from DepartmentEntity d where d.organization.id=?1 and (d.name in (?2) or d.parent is null) and d.deleted = false")
    Collection<DepartmentEntity> getDepartAndRootByOrganIdName(String organId, Collection<String> names);

    @Query("select d from DepartmentEntity d where d.organization.id=?1 and d.id in (?2) and d.deleted = false")
    Collection<DepartmentEntity> getByIds(String organizationId, Collection<String> ids);

    @Modifying
    @Query("update DepartmentEntity d set d.deleted =true,d.parent= null,d.name = concat(d.name,'#',d.id) ,d.lastUpdatedTime=now() where d.organization.id=?1 and d.id in (?2) and d.parent.id is not null")
    int deleteByIds(String organId, Collection<String> ids);

    @Query("select d from DepartmentEntity d where d.organization.id=?1 and d.deleted = false order by d.parent,d.level")
    Collection<DepartmentEntity> getAllByOrganId(String organId);

    @Query("select d from DepartmentEntity d where d.organization.id=?1 and d.code=?2 and d.deleted = false")
    DepartmentEntity getByOrganIdAndCode(String organId, String code);

    @Query("select d from DepartmentEntity d where d.organization.id=?1 and d.parent is null and d.deleted = false")
    DepartmentEntity getRootByOrganId(String organId);

    @Modifying
    @Query("delete from DepartmentEmployeeRelationEntity x where x.id in (?1)")
    void clearDuplicatedEmployeeRelationIds(Collection<String> ids);

    @Modifying
    @Query("delete from DepartmentEmployeeRelationEntity x where x.employee.id in (?1)")
    void clearDuplicatedEmployeeRelationByEmployeeIds(Collection<String> employeeIds);

    @Modifying
    @Query("delete from DepartmentEmployeeRelationEntity x where x.employee.id in (?1) and x.department.id=?2")
    void clearDuplicatedEmployeeRelationByEmployeeIdsAndDepartId(Collection<String> employeeIds, String destDepartId);

    @Modifying
    @Query("delete from DepartmentAdminEntity x where x.department.id in (?1)")
    void clearDepartmentAdminByDepartIds(Collection<String> destDepartIds);


    @Modifying
    @Query(value = "UPDATE tenant_departments d SET d.index_tree = REPLACE(d.index_tree, ?1, ?2), " +
            " d.level =  (LENGTH(d.index_tree) - LENGTH(REPLACE(d.index_tree, '-', '')))" +
            " WHERE d.organization_id = ?3 AND d.index_tree LIKE ?4 ", nativeQuery = true)
    int updateTreeByDepartmentIndexTree1(String oldTree, String newTree, String organizationId, String oldTreeLike);


    @Modifying
    @Query(value = "UPDATE tenant_department_admins d SET d.department_index_tree = REPLACE(d.department_index_tree, ?1, ?2) " +
            " WHERE d.organization_id = ?3 AND d.department_index_tree LIKE ?4 ", nativeQuery = true)
    int updateTreeByDepartmentIndexTree2(String oldTree, String newTree, String organizationId, String oldTreeLike);

    @Modifying
    @Query(value = "UPDATE tenant_department_employee_relations d SET d.department_index_tree = REPLACE(d.department_index_tree, ?1, ?2) " +
            " WHERE d.department_id IN (SELECT t.id FROM tenant_departments t WHERE t.organization_id = ?3) AND d.department_index_tree LIKE ?4 ", nativeQuery = true)
    int updateTreeByDepartmentIndexTree3(String oldTree, String newTree, String organizationId, String oldTreeLike);

    @Query("select d from DepartmentEntity d where d.organization.id = ?1 and d.indexTree like ?2 and d.deleted = false")
    List<DepartmentEntity> findBySelfAndChild(String organizationId, String indexTree);
}
