/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.domain.services.commands.tenantUsers;

import com.bcxin.Infrastructures.TenantContext;
import com.bcxin.Infrastructures.TenantUserContext;
import com.bcxin.Infrastructures.commands.CommandAbstract;
import com.bcxin.Infrastructures.exceptions.ArgumentTenantException;
import com.bcxin.api.interfaces.tenants.requests.tenantUsers.PlatformUpdateUserBasicRequest;
import org.apache.commons.lang3.StringUtils;

public class PlatformUpdateUserBasicCommand
extends CommandAbstract {
    private final String tenantUserId;
    private final String employeeId;
    private final String operateUserId;
    private final String name;
    private final String telephone;
    private final String operateReason;
    private final String ipAddress;

    public PlatformUpdateUserBasicCommand(String tenantUserId, String employeeId, String operateUserId, String name, String telephone, String operateReason, String ipAddress) {
        this.tenantUserId = tenantUserId;
        this.employeeId = employeeId;
        this.operateUserId = operateUserId;
        this.name = name;
        this.telephone = telephone;
        this.operateReason = operateReason;
        this.ipAddress = ipAddress;
    }

    public static PlatformUpdateUserBasicCommand create(PlatformUpdateUserBasicRequest request) {
        return new PlatformUpdateUserBasicCommand(request.getTenantUserId(), request.getEmployeeId(), request.getOperateUserId(), request.getName(), request.getTelephone(), request.getOperateReason(), request.getIpAddress());
    }

    public void validate() {
        if (StringUtils.isBlank((CharSequence)this.getTenantUserId())) {
            throw new ArgumentTenantException("\u5f53\u524d\u767b\u5f55\u7684\u7528\u6237id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        TenantUserContext.UserModel userModel = TenantContext.getInstance().getUserContext().get();
        if (!userModel.getId().equals(this.getTenantUserId())) {
            throw new ArgumentTenantException("\u5f53\u524d\u767b\u5f55\u7684\u7528\u6237id\u548c\u6240\u4f20\u53c2\u6570\u4e0d\u4e00\u81f4");
        }
        if (StringUtils.isBlank((CharSequence)this.getEmployeeId())) {
            throw new ArgumentTenantException("\u5f53\u524d\u767b\u5f55\u7684\u804c\u5458id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)this.getOperateUserId())) {
            throw new ArgumentTenantException("\u88ab\u64cd\u4f5c\u7684\u7528\u6237id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)this.getName()) && StringUtils.isBlank((CharSequence)this.getTelephone())) {
            throw new ArgumentTenantException("\u65b0\u59d3\u540d\u548c\u65b0\u624b\u673a\u53f7\uff0c\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a");
        }
    }

    public String getTenantUserId() {
        return this.tenantUserId;
    }

    public String getEmployeeId() {
        return this.employeeId;
    }

    public String getOperateUserId() {
        return this.operateUserId;
    }

    public String getName() {
        return this.name;
    }

    public String getTelephone() {
        return this.telephone;
    }

    public String getOperateReason() {
        return this.operateReason;
    }

    public String getIpAddress() {
        return this.ipAddress;
    }
}

