package com.bcxin.tenant.backend.tasks;

import com.bcxin.tenant.backend.components.SubscriberEventActionComponent;
import com.bcxin.tenant.domain.readers.TenantDbReader;
import com.bcxin.tenant.domain.repositories.EventSubscriberRepository;
import org.springframework.core.task.TaskExecutor;
import org.springframework.stereotype.Component;
import java.util.Collection;

@Component
public class V5SyncNormalTenantEventTask extends V5SyncTenantEventTaskAbstract {
    public V5SyncNormalTenantEventTask(EventSubscriberRepository subscriberRepository,
                                       SubscriberEventActionComponent subscriberEventActionComponent, TaskExecutor taskExecutor, TenantDbReader dbReader) {
        super(subscriberRepository, subscriberEventActionComponent, taskExecutor, dbReader);
    }

    @Override
    protected Collection<String> getPendingEventIds(Collection<String> mapKeys) {
        return this.dbReader.getTopNPendingTenantEvents(mapKeys, false, 100);
    }

    @Override
    public String getTaskName() {
        return "v5.sync.data.tasks.normal";
    }
}
