package com.bcxin.tenant.backend.tasks;

import com.bcxin.tenant.backend.components.SubscriberEventActionComponent;
import com.bcxin.tenant.domain.readers.TenantDbReader;
import com.bcxin.tenant.domain.repositories.EventSubscriberRepository;
import org.springframework.core.task.TaskExecutor;
import org.springframework.stereotype.Component;

import java.util.Collection;

@Component
public class V5SyncFailedTenantEventTask extends V5SyncTenantEventTaskAbstract {
    public V5SyncFailedTenantEventTask(EventSubscriberRepository subscriberRepository,
                                       SubscriberEventActionComponent subscriberEventActionComponent,
                                       TaskExecutor taskExecutor, TenantDbReader dbReader) {
        super(subscriberRepository, subscriberEventActionComponent, taskExecutor, dbReader);
    }

    @Override
    protected Collection<String> getPendingEventIds(Collection<String> mapKeys) {
        return this.dbReader.getTopNPendingTenantEvents(mapKeys, true, 100);
    }

    @Override
    public String getTaskName() {
        return "v5.sync.data.tasks.failed";
    }
}
