package com.bcxin.tenant.backend.tasks;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.bcxin.Infrastructures.components.JsonProvider;
import com.bcxin.api.interfaces.rbacs.RbacCategoryRpcProvider;
import com.bcxin.api.interfaces.rbacs.requests.BatchCategoryResourceRequest;
import com.bcxin.tenant.backend.V5AppConfig;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.util.EntityUtils;
import org.springframework.stereotype.Component;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.stream.Collectors;

@Component
public class V5AppRoleSyncTask extends TaskAbstract{

    private final HttpClient httpClient;
    private final V5AppConfig v5AppConfig;
    private final JsonProvider jsonProvider;
    private final RbacCategoryRpcProvider categoryRpcProvider;

    public V5AppRoleSyncTask(HttpClient httpClient,
                             V5AppConfig v5AppConfig,
                             JsonProvider jsonProvider,
                             RbacCategoryRpcProvider categoryRpcProvider) {
        this.httpClient = httpClient;
        this.v5AppConfig = v5AppConfig;
        this.jsonProvider = jsonProvider;
        this.categoryRpcProvider = categoryRpcProvider;
    }


    @Override
    protected void runCore() {
        String url = v5AppConfig.getSiteEndPoint("/v3/extends/app-roles");
        HttpGet httpGet = new HttpGet(url);
        //StringEntity bodyEntity = new StringEntity("", ContentType.create(ContentType.TEXT_PLAIN.getMimeType(), Charset.defaultCharset()));
        try {
            HttpResponse response = this.httpClient.execute(httpGet);
            String responseBody = EntityUtils.toString(response.getEntity());
            Collection<JSONObject> result = this.jsonProvider.toObjects(JSONObject.class, responseBody);

            Collection<BatchCategoryResourceRequest.CategoryRequest> categoryRequests =
                    result.stream().map(ii -> {
                        String id = ii.getString("id");
                        String name = ii.getString("name");
                        JSONArray jsonArray = ii.getJSONArray("roles");
                        Collection<BatchCategoryResourceRequest.CategoryResourceRequest> resourceRequests = new ArrayList<>();
                        for (Object obj : jsonArray.stream().toArray()) {
                            JSONObject roleObject = (JSONObject) obj;
                            String roleId = roleObject.getString("id");
                            String roleName = roleObject.getString("name");
                            resourceRequests.add(new BatchCategoryResourceRequest.CategoryResourceRequest(roleId, roleName));
                        }

                        return new BatchCategoryResourceRequest.CategoryRequest(id, name, resourceRequests);
                    }).collect(Collectors.toList());

            this.categoryRpcProvider.batch(new BatchCategoryResourceRequest(categoryRequests));

        } catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public String getTaskName() {
        return "v5.app.sync.roles";
    }
}
