package com.bcxin.tenant.backend.tasks;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.HashUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.db.DbUtil;
import cn.hutool.db.Entity;
import cn.hutool.http.HttpResponse;
import cn.hutool.http.HttpUtil;
import cn.hutool.json.JSONUtil;
import cn.hutool.log.Log;
import cn.hutool.log.LogFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import javax.sql.DataSource;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 湖南内网审计数据报文组装业务。
 */
@Component
public class HuNanLogReportTask extends TaskAbstract{
    private static final Log log = LogFactory.get();
    //查询日志列表
    private static String  logListSql= "SELECT  config_key ,config_name  ,config_value   " +
            "from  sys_config where config_name = 'hunan_log_report'  and active ='1';" ;
    private final DataSource directlySharedAppDataSource;
    public HuNanLogReportTask( @Qualifier("directlySharedAppDataSource") DataSource directlySharedAppDataSource) {
        this.directlySharedAppDataSource = directlySharedAppDataSource;
    }

    @Override
    public String getTaskName() {
        return "log.event.sync";
    }

    @Override
    protected void runCore() {
        log.error("------审计日志上传定时任务开始执行------");
        log.error("查询日志列表:{}"+logListSql);
        String logName = "";
        String version ="";
        try {
            List<Entity> query = DbUtil.use(directlySharedAppDataSource).query(logListSql);
            log.error("数据库查询结果：{}",query);
            if (!query.isEmpty()) {
                for (int i = 0; i < query.size(); i++) {
                    logName = "" + query.get(i).get("config_key");
                    version = "" + query.get(i).get("config_value");
                    log.error("湖南审计日志类别："+logName);
                    log.error("湖南审计当前版本号："+version);
                    if (StrUtil.isEmpty(version)){
                        log.error("湖南审计日志类别版本号为空：跳出循环，上报另一个日志----->请检查版本号为什么为空"+logName);
                        break;
                    }
                    List<HashMap<String, String>> collect = this.logHandel(this.sqlHandel(logName,version));
                    log.error("参数: {} ",collect);
                    if(0==collect.size()){
                        log.error("查询到审计数据0条: {} ");
                    }else {
                        int index = collect.size() - 1;
                        String lastVer = collect.get(index).get("version");
                        //去除原来mapList里map里面version 键值对
                        List<HashMap<String, String>> hashMaps = this.deleteKey(collect,"version");
                        int status = this.request(JSONUtil.toJsonStr(hashMaps));
                        if (200 ==status){
                            log.error("状态码" + status);
                            this.updateVersion(logName,lastVer);
                            log.error("请求成功: {} ", DateUtil.now());
                        }
                    }
                }
            }
        } catch (SQLException throwables) {
            throwables.printStackTrace();
        }
    }


    private  List<HashMap<String, String>>  logHandel(String  sql) throws SQLException {
        List<HashMap<String, String>> collect = DbUtil.use(directlySharedAppDataSource).query(sql).stream().map(item -> {
            HashMap<String, String> par = new HashMap<>();
            String num_id = "" + item.get("numId");
            String reg_id = "430000000115";
            String user_id = "" + item.get("userId");
            String organization = "" + item.get("organization");
            String organization_id = "" + item.get("organization");
            String user_name = "" + item.get("userName");
            String operate_time = "" + item.get("operateTime");
            String terminal_id = "" + item.get("terminalId");
            String operate_type = "" + item.get("operateType");
            String operate_result ="" +  item.get("operateResult");
            String errorCode = "" +item.get("errorCode");
            String operate_name = ""  +item.get("operateName");
            String operate_condition = "" + item.get("operateCondition");
            String ver = ""+ item.get("version");
            par.put("num_id",  num_id);
            par.put("reg_id", reg_id);
            par.put("user_id", user_id);
            par.put("organization", organization);
            par.put("organization_id", organization_id);
            par.put("user_name", user_name);
            par.put("operate_time", this.handTime(operate_time));
            par.put("terminal_id", terminal_id);
            par.put("operate_type", operate_type);
            par.put("operate_result", operate_result);   //操作结果：1 成功 2、失败
            par.put("error_code",errorCode);
            par.put("operate_name", operate_name);
            par.put("operate_condition",operate_condition);   //用户操作条件 1、成功 2、失败
            par.put("version",ver);
            log.error("湖南审计当前更新的参数：{}",par);
            return par;
        }).collect(Collectors.toList());
        return  collect;
    }
    //    根据日志类别和日志版本号修改日志查询sql
    private String sqlHandel(String sqlName,String version){
        String  initSql= "SELECT  * from %s   where version > %s  limit 10 ; ";
        String sqlHandel = String.format(initSql, sqlName, version);
        log.error("查询日志sql",sqlHandel);
        return sqlHandel;
    }

    private void  updateVersion(String  configKey,String version){
        String sql = String.format("UPDATE sys_config set config_value = '%s' where config_key = '%S' ;",version,configKey);
        log.error(String.format("更新日志 %s 版本号为%s .",configKey,version));
        try {
            DbUtil.use(directlySharedAppDataSource).execute(sql);
        } catch (SQLException throwables) {
            throwables.printStackTrace();
        }
    }
    private int request(String body){
        String url = "http://10.142.1.99:8080/hnasReceive/AcceptLogs";
        String sysId = "430000000115";
        String verfyCode = "wXNF3WGweNCykRjj";
        HttpResponse response = HttpUtil.createPost(url).header("sysId", sysId).header("verfyCode", verfyCode)
                .body(body).execute();
        log.error("执行结果" + response.body());
        return response.getStatus();
    }

    //去除Map数据的某个字段数据的版本字段
    public List<HashMap<String, String>>  deleteKey( List<HashMap<String, String>>  collect ,String key){
        List<HashMap<String, String>> hashMaps = new ArrayList<>();
        for (HashMap<String,String> hashMap :collect){
            hashMap.remove(key);
            hashMaps.add(hashMap);
        }
        return hashMaps ;
    }
    //去除时间后面的.0
    public String handTime(String time){
        if (time.contains(".0")){
            return time.replace(".0","");
        }
        return time;
    }

}
