package com.bcxin.tenant.backend.tasks;

import cn.hutool.db.Db;
import cn.hutool.db.DbUtil;
import cn.hutool.log.Log;
import cn.hutool.log.LogFactory;
import com.bcxin.tenant.domain.repositories.EmployeeRepository;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

import javax.sql.DataSource;
import java.util.List;
import java.util.stream.Collectors;

@Component
public class EmployeeCredentialSyncTask extends TaskAbstract{
    private static String sql = "SELECT\n" +
            "tucd.idnum,\n" +
            "CONCAT(\n" +
            "\"UPDATE tenant_user_credentials set tenant_user_id = '\" ,(\n" +
            "SELECT\n" +
            "tenant_user_id\n" +
            "FROM\n" +
            "tenant_user_credentials\n" +
            "WHERE\n" +
            "number = tucd.idnum  limit 1\n" +
            "), \"', valid_date_to = '\",IF(tucd.state = 1,'9999-12-31','1970-01-01'),\"' where id = '\",tuc.id,\"';\"\n" +
            ") as updatesql\n" +
            "FROM\n" +
            "tenant_user_credentials tuc\n" +
            "JOIN tenant_user_credential_details tucd ON tuc.id = tucd.id\n" +
            "where tuc.tenant_user_id is null\n" +
            "and EXISTS (SELECT 1 from tenant_user_credentials where number = tucd.idnum)  limit 100;";

    private final EmployeeRepository employeeRepository;
    private final DataSource dataSource;
    private static final Log log = LogFactory.get();
    public EmployeeCredentialSyncTask (EmployeeRepository employeeRepository,DataSource obpmDataSource) {
        this.employeeRepository = employeeRepository;
        this.dataSource = obpmDataSource;
    }

    @Override
    protected void runCore() {
        if (false) {
            log.debug("开始补充证书信息 ===============");
            Db duse = DbUtil.use(dataSource);
            try {
                List<String> updatesqls = duse.query(sql).stream().map(item -> {

                    return "" + item.get("updatesql");

                }).collect(Collectors.toList());

                log.debug("补充的sql =========={}", updatesqls.toString());

                int[] ints = duse.executeBatch(updatesqls);


                log.debug("执行成功 =========={}" + ints.length);
            } catch (Exception e) {
                log.error("执行失败 =========={}" + e.getMessage());
            }
        }
    }

    @Override
    public String getTaskName() {
        return "employee.credential.data";
    }
}
