package com.bcxin.tenant.backend.tasks;

import com.bcxin.Infrastructures.utils.StringUtils;
import com.bcxin.api.interfaces.tenants.OrganizationStatisticsRpcProvider;
import com.bcxin.api.interfaces.tenants.TenantDepartmentScheduledDeleteRpcProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.scheduling.support.CronTrigger;
import org.springframework.stereotype.Component;

import javax.annotation.PostConstruct;

/**
 * description：定时删除部门数据、离职部门人员
 * author：linchunpeng
 * date：2024/12/13
 */
@Component
public class DepartmentDeleteTask extends TaskAbstract{
    private final Logger logger = LoggerFactory.getLogger(DepartmentDeleteTask.class);

    private final TenantDepartmentScheduledDeleteRpcProvider tenantDepartmentScheduledDeleteRpcProvider;


    public DepartmentDeleteTask(TenantDepartmentScheduledDeleteRpcProvider tenantDepartmentScheduledDeleteRpcProvider) {
        this.tenantDepartmentScheduledDeleteRpcProvider = tenantDepartmentScheduledDeleteRpcProvider;
    }


    @Override
    protected void runCore() {
        try{
            //定时删除部门数据、离职部门人员
            tenantDepartmentScheduledDeleteRpcProvider.executeDelete();
        }catch (Exception e){
            logger.error(String.format("定时删除部门数据、离职部门人员出现异常：%s",e.getMessage()));
        }
    }

    @Override
    public String getTaskName() {
        return "department.delete.task";
    }
}
