package com.bcxin.tenant.backend.components.handlers.impls;

import com.bcxin.Infrastructures.UnitWork;
import com.bcxin.Infrastructures.components.JsonProvider;
import com.bcxin.Infrastructures.components.RetryProvider;
import com.bcxin.Infrastructures.enums.CredentialType;
import com.bcxin.Infrastructures.enums.ProcessedStatus;
import com.bcxin.api.interfaces.identities.IdentityRpcProvider;
import com.bcxin.api.interfaces.identities.requests.SignUpRequest;
import com.bcxin.tenant.backend.components.handlers.SubscriberEventActionHandler;
import com.bcxin.tenant.domain.entities.*;
import com.bcxin.tenant.domain.entities.reports.EmployeeReportEntity;
import com.bcxin.tenant.domain.enums.EventAction;
import com.bcxin.tenant.domain.readers.TenantDbReader;
import com.bcxin.tenant.domain.repositories.*;
import com.bcxin.tenant.domain.snapshots.TenantEmployeeSnapshot;
import com.bcxin.tenant.domain.utils.ExecuteUtils;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

/**
 * 同步推送保安员的用户信息
 */
@Component
public class SyncSubscriberEventActionHandlerImpl implements SubscriberEventActionHandler {
    private final JsonProvider jsonProvider;
    private final TenantDbReader dbReader;
    private final UnitWork unitWork;
    private final EmployeeReportRepository employeeReportRepository;
    private final EventSubscriberRepository eventSubscriberRepository;
    private final TenantUserRepository tenantUserRepository;
    private final IdentityRpcProvider identityRpcProvider;
    private final TenantEventRepository tenantEventRepository;
    private final RetryProvider retryProvider;
    private final EventSubscribedActionLogRepository eventSubscribedActionLogRepository;

    public SyncSubscriberEventActionHandlerImpl(JsonProvider jsonProvider,
                                                TenantDbReader dbReader,
                                                UnitWork unitWork,
                                                EmployeeReportRepository employeeReportRepository,
                                                EventSubscriberRepository eventSubscriberRepository,
                                                TenantUserRepository tenantUserRepository,
                                                IdentityRpcProvider identityRpcProvider,
                                                TenantEventRepository tenantEventRepository,
                                                RetryProvider retryProvider,
                                                EventSubscribedActionLogRepository eventSubscribedActionLogRepository) {
        this.jsonProvider = jsonProvider;
        this.dbReader = dbReader;
        this.unitWork = unitWork;
        this.employeeReportRepository = employeeReportRepository;
        this.eventSubscriberRepository = eventSubscriberRepository;
        this.tenantUserRepository = tenantUserRepository;
        this.identityRpcProvider = identityRpcProvider;
        this.tenantEventRepository = tenantEventRepository;
        this.retryProvider = retryProvider;
        this.eventSubscribedActionLogRepository = eventSubscribedActionLogRepository;
    }

    @Override
    public void execute(EventSubscriberEntity subscriber,Collection<String> eventIds) {
        if (!StringUtils.hasLength(subscriber.getSelector())) {
            return;
        }

        Collection<String> identitySelectorMapKeys = Stream.of(EventAction.TenantUserAfterCreatedEventForIdentity.name()).collect(Collectors.toList());

        if (identitySelectorMapKeys.contains(subscriber.getSelector())) {
            syncIdentity(subscriber, identitySelectorMapKeys, eventIds);
        }
    }

    private void syncIdentity(EventSubscriberEntity subscriber,Collection<String> mapKeys,Collection<String> eventIds) {
        Collection<TenantEventEntity> tenantEvents = getNBySelector(subscriber.getLastVersion(),mapKeys,eventIds);
        if (tenantEvents.size() == 0) {
            return;
        }

        Collection<String> tenantIds =
                tenantEvents.stream().map(ii -> ii.getContent()).collect(Collectors.toList());

        Collection<TenantUserEntity> tenantUsers = this.tenantUserRepository.getByIds(tenantIds);
        tenantUsers.forEach(tenantUser -> {
            Optional<TenantEventEntity> tenantEventOptional = tenantEvents.stream().filter(ii -> ii.getContent().equals(tenantUser.getId()))
                    .findFirst();
            if (tenantEventOptional.isPresent()) {
                ExecuteUtils.executeTenantEventAction(tenantEventOptional.get(), subscriber, () -> {
                            Collection<SignUpRequest.CredentialRequest> credentialRequests = new ArrayList<>();

                            final Collection<CredentialType> validCredentialTypes =
                                    Arrays.stream(CredentialType.values()).filter(ii -> ii.isIdentityNo())
                                            .collect(Collectors.toList());
                            Collection<TenantUserCredentialsEntity> validTenantUserCredentials =
                                    tenantUser.getCredentials().stream()
                                            .filter(ii -> validCredentialTypes.contains(ii.getCredentialType())).collect(Collectors.toList());

                            for (TenantUserCredentialsEntity credential : validTenantUserCredentials) {
                                credentialRequests.add(SignUpRequest.CredentialRequest.create(credential.getCredentialType(), credential.getNumber()));
                            }

                            SignUpRequest request = SignUpRequest.create(
                                    tenantUser.getId(), tenantUser.getTelephone(), tenantUser.getSelectedCredential().getNumber(), tenantUser.getName(), credentialRequests);

                            this.identityRpcProvider.signUp(request);
                        }, retryProvider, eventSubscribedActionLogRepository,
                        eventSubscriberRepository, tenantEventRepository, unitWork);
            }
        });
    }

    private Collection<TenantEventEntity> getNBySelector(Long version, Collection<String> mapKeys,Collection<String> eventIds)
    {
        Collection<TenantEventEntity> tenantEvents = this.dbReader.getTopNTenantEvents(version, mapKeys, eventIds,100);

        return tenantEvents;
    }
}
