package com.bcxin.api.interfaces.tenants.responses;

import com.bcxin.Infrastructures.entities.OperatorValueType;
import com.bcxin.Infrastructures.enums.OccupationType;
import lombok.Data;

import javax.persistence.Embedded;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import java.io.Serializable;
import java.sql.Timestamp;

/**
 * @author linqinglin
 * @date 2021/12/08 0008 16:08
 */
@Data
public class InviteAttendSiteResponse implements Serializable {

    /**
     * 邀请id
     */
    private String id;

    /**
     * 驻勤点id
     */
    private String attendSiteId;

    /**
     * 驻勤点名称
     */
    private String attendSiteName;

    /**
     * 部门id
     */
    private String departId;

    /**
     * 部门名称
     */
    private String departName;

    /**
     * 组织id
     */
    private String organizationId;

    /**
     * 组织名称
     */
    private String organizationName;

    /**
     * 职业类型: 保安员, 其他
     */
    @Enumerated(EnumType.ORDINAL)
    private OccupationType occupationType;

    /**
     * 链接有效截止日期
     */
    private Timestamp endTime;

    private String areaCode;

    @Embedded
    private OperatorValueType creator;
}
