package com.bcxin.api.interfaces.tenants.responses;

import com.bcxin.api.interfaces.ResponseAbstract;
import lombok.Getter;

import java.util.Collection;
import java.util.HashSet;

@Getter
public class ExternalGroupResponse extends ResponseAbstract {
    private final String id;
    private final String name;

    private final int totalCount;
    private final int displayOrder;
    private final Collection<ExternalGroupResponse> children;

    public ExternalGroupResponse(String id, String name, int totalCount, int displayOrder) {
        this.id = id;
        this.name = name;
        this.totalCount = totalCount;
        this.displayOrder = displayOrder;
        this.children = new HashSet<>();
    }

    public static ExternalGroupResponse create(String id, String name,int totalCount,  int displayOrder) {
        return new ExternalGroupResponse(id, name,totalCount, displayOrder);
    }

    public void assignChild(ExternalGroupResponse child) {
        this.getChildren().add(child);
    }
}
