package com.bcxin.api.interfaces.tenants.responses;

import com.bcxin.api.interfaces.enums.DepartImPermissionType;
import lombok.Getter;
import org.springframework.util.CollectionUtils;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.stream.Collectors;

@Getter
public class DepartmentTreeGetResponse extends DepartmentGetResponse {
    private final Collection<DepartmentTreeGetResponse> children;
    private final Collection<DataItem> allowedDeparts;

    public Collection<String> getAllDepartIds() {
        if (CollectionUtils.isEmpty(this.getChildren())) {
            return Collections.singleton(this.getId());
        }
        Collection<String> departIds = this.getChildren().stream().flatMap(ii -> ii.getAllDepartIds().stream())
                .collect(Collectors.toList());
        departIds.add(this.getId());
        return departIds;
    }


    public DepartmentTreeGetResponse(String id, String name, String parentId, int displayOrder,
                                     int totalMember,
                                     int level,
                                     DepartImPermissionType departIMPermissionType,
                                     Collection<String> allowedDepartIds,
                                     Collection<DepartmentTreeGetResponse> children, Collection<DataItem> allowedDeparts) {
        super(id, name, parentId, displayOrder, totalMember, departIMPermissionType, allowedDepartIds, level);
        this.children = children;
        this.allowedDeparts = allowedDeparts;
    }


    public static DepartmentTreeGetResponse create(String id, String name, String parentId, int displayOrder,
                                                   int totalMember,
                                                   int level,
                                                   DepartImPermissionType departIMPermissionType,
                                                   Collection<String> allowedDepartIds,
                                                   Collection<DepartmentTreeGetResponse> children,
                                                   Collection<DataItem> allowedDeparts) {
        if (children == null) {
            children = new ArrayList<>();
        }
        children = children.stream()
                .sorted((ix, it) -> {
                    return ix.getDisplayOrder() - it.getDisplayOrder();
                }).collect(Collectors.toList());

        return new DepartmentTreeGetResponse(id, name, parentId, displayOrder, totalMember, level, departIMPermissionType,
                allowedDepartIds, children, allowedDeparts);
    }

    @Getter
    public static class DataItem implements Serializable {
        private final String id;
        private final String name;

        public DataItem(String id, String name) {
            this.id = id;
            this.name = name;
        }

        public static DataItem create(String id, String name) {
            return new DataItem(id, name);
        }
    }
}
