package com.bcxin.api.interfaces.tenants.responses;

import com.bcxin.Infrastructures.enums.*;
import lombok.Getter;
import org.apache.commons.lang3.time.DateUtils;
import org.springframework.util.StringUtils;

import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;

@Getter
public class ContractGetResponse implements Serializable {
    private final String id;
    private final String name;
    private final String idNum;
    @Enumerated(EnumType.ORDINAL)
    private final CredentialType credentialType;
    private final String aName;
    private final String bName;
    private final Date beginDate;
    private final Date endDate;
    private final boolean dateLimitless;
    private final String attachment;
    private final String note;
    private final String employeeId;

    private final String employeeName;
    private final String employeeTelephone;
    private final String employeeDepartName;
    private final OccupationType employeeOccupationType;
    private final EmploymentStatus employeeStatus;
    private final ValidStatus status;

    private final String operator;
    private final String operatorTime;
    private ContractStatus contractStatus;
    private Date createTime;

    public ContractGetResponse(String id,
                               String name,
                               String idNum,
                               CredentialType credentialType,
                               String aName,
                               String bName,
                               String employeeId,
                               String employeeName, String employeeTelephone,
                               String employeeDepartName, OccupationType employeeOccupationType,
                               EmploymentStatus employeeStatus, Date beginDate, Date endDate,
                               TrueFalseStatus dateLimitless, String attachment,String note,ValidStatus status,
                               String operator,
                               String operatorTime,
                               ContractStatus contractStatus,
                               Date createTime) {
        this.id = id;
        this.name = name;
        this.idNum = idNum;
        this.credentialType = credentialType;
        this.aName = aName;
        this.bName = bName;
        this.employeeId = employeeId;

        this.employeeName = employeeName;
        this.employeeTelephone = employeeTelephone;
        this.employeeDepartName = employeeDepartName;
        this.employeeOccupationType = employeeOccupationType;
        this.employeeStatus = employeeStatus;
        this.beginDate = beginDate;
        this.endDate = endDate;
        this.dateLimitless = dateLimitless == TrueFalseStatus.True;
        this.attachment = attachment;
        this.note = note;
        this.status = status;
        this.operator = operator;
        this.operatorTime = operatorTime;
        this.contractStatus=contractStatus;
        this.createTime=createTime;
    }

    public String getDateRang() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        if (this.getEndDate() == null) {
            return String.format("%s至永远", dateFormat.format(this.getBeginDate()));
        } else {
            return String.format("%s至%s", dateFormat.format(this.getBeginDate()), dateFormat.format(this.getEndDate()));
        }
    }

    public String getEmployeeStatusDesc() {
        if (this.getEmployeeStatus() == EmploymentStatus.OffJob) {
            return "离职";
        }

        return "在职";
    }

    public String getContractStatusDesc() {
        Date today = new Date();
        Date dueDate = DateUtils.addMonths(new Date(),1);
        String ContractStatusDesc="";
        this.getContractStatus();
        if(this.getContractStatus()!=null){
            if (this.getContractStatus()==ContractStatus.STOP&&this.getStatus() == ValidStatus.InValid ||this.getEmployeeStatus() == EmploymentStatus.OffJob ||
                    (!this.dateLimitless && this.getEndDate() != null && this.getEndDate().before(today))) {
                ContractStatusDesc="终止";
                return ContractStatusDesc;
            }
            if (this.getContractStatus()==ContractStatus.INCOMPLETE&&this.getStatus() == ValidStatus.Valid &&!StringUtils.hasLength(this.getAttachment())) {
                ContractStatusDesc="待完善";
                return ContractStatusDesc;
            }

            if (this.getContractStatus()==ContractStatus.BEEFFECT&&this.getStatus() == ValidStatus.Valid &&this.getBeginDate().after(today)) {
                ContractStatusDesc="待生效";
                return ContractStatusDesc;
            }

            if(this.getContractStatus()==ContractStatus.DUE&&this.getStatus() == ValidStatus.Valid &&this.getEndDate().after(new Date()) && this.getEndDate().before(dueDate)&&this.getBeginDate().before(today)){
                ContractStatusDesc="即将到期";
                return ContractStatusDesc;
            }
            if(this.getContractStatus()==ContractStatus.EFFECT){
                ContractStatusDesc="有效";
                return ContractStatusDesc;
            }
        }else {
            if (this.getStatus() == ValidStatus.InValid ||this.getEmployeeStatus() == EmploymentStatus.OffJob ||
                    (!this.dateLimitless && this.getEndDate() != null && this.getEndDate().before(today))) {
                ContractStatusDesc="终止";
                return ContractStatusDesc;
            }
            if (this.getStatus() == ValidStatus.Valid &&!StringUtils.hasLength(this.getAttachment())) {
                ContractStatusDesc="待完善";
                return ContractStatusDesc;
            }
            if (this.getStatus() == ValidStatus.Valid &&this.getBeginDate().after(today)) {
                ContractStatusDesc="待生效";
                return ContractStatusDesc;
            }
            if(this.getStatus() == ValidStatus.Valid &&this.getEndDate().after(new Date()) && this.getEndDate().before(dueDate)&&this.getBeginDate().before(today)){
                ContractStatusDesc="即将到期";
                return ContractStatusDesc;
            }
            if(this.getStatus() == ValidStatus.Valid && this.getEndDate().after(dueDate)&&this.getBeginDate().before(today)) {
                ContractStatusDesc="有效";
                return ContractStatusDesc;
            }
        }

        return ContractStatusDesc;

    }

    public String getBeginDateDesc() {
        if (this.getBeginDate() == null) {
            return null;
        }

        return new SimpleDateFormat("yyyy-MM-dd").format(this.getBeginDate());
    }

    public String getEndDateDesc() {
        if (this.getEndDate() == null) {
            return null;
        }

        return new SimpleDateFormat("yyyy-MM-dd").format(this.getEndDate());
    }

    public String getFileName() {
        if (!StringUtils.hasLength(this.getAttachment())) {
            return null;
        }

        if (!this.getAttachment().contains("/")) {
            return this.getAttachment();
        }

        String[] itemNames = this.getAttachment().split("/");
        return itemNames[itemNames.length - 1];
    }

    public static ContractGetResponse create(String id,
                                             String name,
                                             String idNum,
                                             CredentialType credentialType,
                                             String aName,
                                             String bName,
                                             String employeeId,
                                             String employeeName, String employeeTelephone,
                                             String employeeDepartName, OccupationType employeeOccupationType,
                                             EmploymentStatus employeeStatus, Date beginDate, Date endDate,
                                             TrueFalseStatus dateLimitless, String attachment,String note,ValidStatus status,
                                             String operator,
                                             String operatorTime,
                                             ContractStatus contractStatus,
                                             Date createTime) {
        return new ContractGetResponse(id,
                name,idNum,credentialType,aName,bName,employeeId,
                employeeName, employeeTelephone, employeeDepartName,
                employeeOccupationType, employeeStatus, beginDate, endDate, dateLimitless,
                attachment, note,status,
                operator,
                operatorTime,
                contractStatus,
                createTime);
    }
}
