package com.bcxin.api.interfaces.tenants.requests.organizations;

import com.bcxin.api.interfaces.RequestAbstract;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;

@ApiModel("企业修改监管机构")
@Data
public class CompanyUpdateSuperviseRequest extends RequestAbstract {

    private String id;

    //监管归属
    @ApiModelProperty(value = "监管地区code", required = true)
    @NotBlank(message = "监管地区code不能为空")
    private String placeOfSupervise;

    @ApiModelProperty(value = "监管机构id", required = true)
    @NotBlank(message = "监管机构id不能为空")
    private String superviseDepartId;

    @ApiModelProperty(value = "监管机构名称")
    private String superviseDepartName;

}
