package com.bcxin.api.interfaces.tenants;

import com.bcxin.api.interfaces.tenants.requests.organizationRelationship.OrganizationRelationshipCreateRequest;
import com.bcxin.api.interfaces.tenants.requests.organizationRelationship.OrganizationRelationshipInfoUpdateRequest;
import com.bcxin.api.interfaces.tenants.requests.organizationRelationship.OrganizationRelationshipStatusUpdateRequest;
import com.bcxin.api.interfaces.tenants.requests.organizationRelationship.OrganizationStructureQueryRequest;
import com.bcxin.api.interfaces.tenants.responses.OrgRelationResponse;
import com.bcxin.api.interfaces.tenants.responses.OrganizationRelationshipResponse;
import com.bcxin.api.interfaces.tenants.responses.OrganizationStructureResponse;
import org.springframework.stereotype.Component;

import java.util.Collection;
import java.util.List;

@Component
public interface OrganizationRelationshipRpcProvider {

    public void join( OrganizationRelationshipCreateRequest organizationRelationshipCreateRequest);
    public OrganizationRelationshipResponse findRelationshipDetailById(long id);

    OrganizationStructureResponse getOrganizationStructure(OrganizationStructureQueryRequest request);

    public void updateStatus(String organizationId,OrganizationRelationshipStatusUpdateRequest organizationRelationshipUpdateRequest);

    public void updateRelationshipInfo(OrganizationRelationshipInfoUpdateRequest organizationRelationshipUpdateRequest);

    void delete(Collection<Long> ids,String organizationId);

    List<OrgRelationResponse> getParentList(String organizationId);

    List<OrgRelationResponse> getChildrenList(String organizationId);
}
