package com.bcxin.api.interfaces.identities.responses;

import com.bcxin.api.interfaces.ResponseAbstract;
import com.bcxin.api.interfaces.enums.UpdatePasswordType;
import lombok.Getter;

@Getter
public class SignInResponse extends ResponseAbstract {
    private final String token;
    private final String name;
    private final String idNum;
    //修改密码类型，0：无需提示，1：还没修改过密码，2：上次修改密码的时间超过90天
    private final Integer updatePasswordType;
    private final String updatePasswordMsg;

    protected SignInResponse(String token, String name, String idNum, UpdatePasswordType updatePasswordType) {
        this.token = token;
        this.name = name;
        this.idNum = idNum;
        this.updatePasswordType = updatePasswordType == null ? null : updatePasswordType.ordinal();
        if (this.updatePasswordType != null && this.updatePasswordType == UpdatePasswordType.NO_UPDATE.ordinal()) {
            this.updatePasswordMsg = "系统检测到您的初始密码过于简单，为确保安全，请前往修改登录密码。";
        } else if (this.updatePasswordType != null && this.updatePasswordType == UpdatePasswordType.EXCEED_TIME.ordinal()) {
            this.updatePasswordMsg = "您的密码已使用了90天，为确保安全，请前往修改登录密码。";
        } else {
            this.updatePasswordMsg = "";
        }
    }

    public static SignInResponse create(String token, String name, String idNum, UpdatePasswordType updatePasswordType) {
        return new SignInResponse(token, name, idNum, updatePasswordType);
    }
}
