package com.bcxin.Infrastructures.exceptions;

import com.bcxin.Infrastructures.enums.UserCheckedStatus;
import lombok.Getter;

@Getter
public class ConfirmCheckStatusException extends TenantExceptionAbstract {
    private final String tenantUserId;
    private final UserCheckedStatus checkedStatus;

    public ConfirmCheckStatusException(String tenantUserId, UserCheckedStatus chkStatus) {
        this(tenantUserId, chkStatus, String.format("非法核验: 当前用户(%s)的核验状态为:%s", tenantUserId, chkStatus.getTypeName()));
    }

    public ConfirmCheckStatusException(String tenantUserId, UserCheckedStatus checkedStatus, String msg) {
        super(msg);
        this.tenantUserId = tenantUserId;
        this.checkedStatus = checkedStatus;
    }
}
