package com.bcxin.Infrastructures.enums;

public enum InvitedStatus implements SwaggerDisplayEnum {
    /**
     * 待处理
     */
    Pending{
        @Override
        public String getTypeName(){return "待处理";}

        @Override
        public boolean isIdentityNo() {
            return false;
        }
    },
    /**
     * 确认入职
     */
    Agree{
        @Override
        public String getTypeName(){return "确认入职";}

        @Override
        public boolean isIdentityNo() {
            return false;
        }
    },
    /**
     * 拒绝入职
     */
    Refuse{
        @Override
        public String getTypeName(){return "拒绝入职";}

        @Override
        public boolean isIdentityNo() {
            return false;
        }
    };

    public abstract String getTypeName();

    public abstract boolean isIdentityNo();

    @Override
    public String description() {
        return this.ordinal() + "-" + this.getTypeName();
    }
}
