package com.bcxin.Infrastructures.enums;

/**
 * description: 经济类型-枚举类
 * author: linchunpeng
 * date:  2023-05-05 10:58
 */
public enum EconomicType implements SwaggerDisplayEnum {

    /**
     * 空
     */
    None{
        @Override
        public String getTypeName(){return "空";}
    },

    /**
     * 国有经济
     */
    StateOwned{
        @Override
        public String getTypeName(){return "国有经济";}
    },

    /**
     * 集体经济
     */
    Collective{
        @Override
        public String getTypeName(){return "集体经济";}
    },

    /**
     * 私营经济
     */
    Private{
        @Override
        public String getTypeName(){return "私营经济";}
    },

    /**
     * 个体经济
     */
    Individual{
        @Override
        public String getTypeName(){return "个体经济";}
    },

    /**
     * 联营经济
     */
    Pooled{
        @Override
        public String getTypeName(){return "联营经济";}
    },

    /**
     * 股份制
     */
    ShareholdingSystem{
        @Override
        public String getTypeName(){return "股份制";}
    },

    /**
     * 外商投资
     */
    ForeignInvestment{
        @Override
        public String getTypeName(){return "外商投资";}
    },

    /**
     * 港澳台投资与其他经济
     */
    HongKongMacaoAndTaiwan{
        @Override
        public String getTypeName(){return "港澳台投资与其他经济";}
    },

    /**
     * 其他经济
     */
    Other{
        @Override
        public String getTypeName(){return "其他经济";}
    };

    public abstract String getTypeName();

    @Override
    public String description() {
        return this.ordinal() + "-" + this.getTypeName();
    }

}
