package com.bcxin.Infrastructures.enums;

/**
 * 审核状态
 */
public enum ApprovedStatus {
    /**
     * 待审批
     */
    Init {
        @Override
        public String getTypeName() {
            return "待审批";
        }
    },
    /**
     * 审批通过
     */
    Passed {
        @Override
        public String getTypeName() {
            return "审批通过";
        }
    },
    /**
     * 审批未通过
     */
    NoPassed {
        @Override
        public String getTypeName() {
            return "审批未通过";
        }
    },
    /**
     * 已被删除
     */
    Deleted {
        @Override
        public String getTypeName() {
            return "已被删除";
        }
    };


    public abstract String getTypeName();

    public int getValue() {
        return this.ordinal();
    }
}
