package com.bcxin.Infrastructures;
import lombok.Getter;

@Getter
public abstract class CriteriaAbstract {
    private final int pageIndex;
    private final int pageSize;
    private boolean ignorePermission;

    public CriteriaAbstract(int pageIndex, int pageSize) {
        this.pageSize = pageSize;
        this.pageIndex = pageIndex;
    }

    public int getSkip() {
        int index = pageIndex - 1;
        if (index < 0) {
            index = 0;
        }

        return this.getPageSize() * index;
    }

    public void markIgnorePermission(boolean ignorePermission) {
        this.ignorePermission = ignorePermission;
    }
}
